package com.icetech.park.service.work;

import com.icetech.common.domain.Page;
import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.park.domain.dto.QueryWorkOrderDTO;
import com.icetech.park.domain.entity.WorkOrder;
import com.icetech.park.domain.vo.WorkOrderCountVo;
import com.icetech.park.domain.vo.WorkOrderPageVo;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 工单表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2023-11-24
 */
public interface WorkOrderService extends IBaseService<WorkOrder> {

    /**
     * Description: 根据ID查询 工单表对象信息 <br>
     * Version1.0 2023-11-24 by wanggang创建
     *
     * @param id 对象id
     * @return WorkOrder
     */
    WorkOrder getWorkOrderById (Long id);

    /**
     * Description: 新增  工单表对象信息 <br>
     * Version1.0 2023-11-24 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addWorkOrder (WorkOrder entity);

    /**
     * Description: 修改 工单表对象信息 <br>
     * Version1.0 2023-11-24 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyWorkOrder (WorkOrder entity);

    /**
     * Description: 删除  工单表对象信息 <br>
     * Version1.0 2023-11-24 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeWorkOrderById (Long id);

    /**
     * Description: 工单分页接口 <br>
     * Version1.0 2023-11-24 by wanggang创建
     *
     * @param dto       参数
     * @param userId    用户 id
     * @param isCs      是否为工单客服
     * @return  WorkOrderPageVo
     */
    Page<WorkOrderPageVo> page(QueryWorkOrderDTO dto, Long userId, Integer isCs);

    /**
     * Description: 数量查询
     * Version1.0 2023-12-01 by wgy 创建
     * 
     * @param dto       参数
     * @param userId    用户 id
     * @param isCs      是否为工单客服
     * @return com.icetech.park.domain.vo.WorkOrderCountVo       
     */
    List<WorkOrderCountVo> orderCount(QueryWorkOrderDTO dto, Long userId, Integer isCs);
}
