package com.icetech.park.service.visit.impl;

import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.visit.ParkVisituserMapper;
import com.icetech.park.domain.entity.ParkVisituser;
import com.icetech.park.service.visit.ParkVisituserService;
import org.springframework.stereotype.Service;


/**
 * 访客车辆用户次数表 服务实现类
 * <p>
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-04-11
 */
@Service
public class ParkVisituserServiceImpl extends BaseServiceImpl<ParkVisituserMapper, ParkVisituser> implements ParkVisituserService {

    /**
     * Description: 根据ID查询 访客车辆用户次数表对象信息 <br>
     * Version1.0 2024-04-11 by wanggang创建
     *
     * @param id 对象id
     * @return ParkVisituser
     */
    @Override
    public ParkVisituser getParkVisituserById(Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  访客车辆用户次数表对象信息 <br>
     * Version1.0 2024-04-11 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addParkVisituser(ParkVisituser entity) {
        return save(entity);
    }

    /**
     * Description: 修改 访客车辆用户次数表对象信息 <br>
     * Version1.0 2024-04-11 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyParkVisituser(ParkVisituser entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  访客车辆用户次数表对象信息 <br>
     * Version1.0 2024-04-11 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeParkVisituserById(Long id) {
        return removeById(id);
    }

    @Override
    public ParkVisituser getParkVisituserByUserId(Integer userId) {
        return selectLimitOne(ParkVisituser.builder()
                .userId(userId)
                .build());
    }

}
