package com.icetech.park.service.visit;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.park.domain.entity.ParkVisituser;

import java.util.List;

/**
 * 访客车辆用户次数表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-04-11
 */
public interface ParkVisituserService extends IBaseService<ParkVisituser> {

    /**
     * Description: 根据ID查询 访客车辆用户次数表对象信息 <br>
     * Version1.0 2024-04-11 by wanggang创建
     *
     * @param id 对象id
     * @return ParkVisituser
     */
    ParkVisituser getParkVisituserById (Long id);

    /**
     * Description: 新增  访客车辆用户次数表对象信息 <br>
     * Version1.0 2024-04-11 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addParkVisituser (ParkVisituser entity);

    /**
     * Description: 修改 访客车辆用户次数表对象信息 <br>
     * Version1.0 2024-04-11 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyParkVisituser (ParkVisituser entity);

    /**
     * Description: 删除  访客车辆用户次数表对象信息 <br>
     * Version1.0 2024-04-11 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeParkVisituserById (Long id);

    /**
     * 通过用户id获取访客次数
     *
     * @param userId
     * @return
     */
    ParkVisituser getParkVisituserByUserId (Integer userId);

}
