package com.icetech.park.service.vip.impl;

import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.fee.domain.entity.vip.VipPlate;
import com.icetech.park.dao.vip.NewVipPlateMapper;
import com.icetech.park.service.vip.NewVipPlateService;
import org.springframework.stereotype.Service;

/**
 * VIP车辆表 服务实现类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-12-03
 */
@Service
public class NewVipPlateServiceImpl  extends BaseServiceImpl<NewVipPlateMapper, VipPlate> implements NewVipPlateService {

    /**
     * Description: 根据ID查询 VIP车辆表对象信息 <br>
     * Version1.0 2024-12-03 by wanggang创建
     *
     * @param id 对象id
     * @return VipPlate
     */
    @Override
    public VipPlate getVipPlateById (Long id) {
        return getById(id);
    }

    /**
     * Description: 新增  VIP车辆表对象信息 <br>
     * Version1.0 2024-12-03 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    @Override
    public Boolean addVipPlate (VipPlate entity) {
        return save(entity);
    }

    /**
     * Description: 修改 VIP车辆表对象信息 <br>
     * Version1.0 2024-12-03 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean modifyVipPlate (VipPlate entity) {
        return updateById(entity);
    }

    /**
     * Description: 删除  VIP车辆表对象信息 <br>
     * Version1.0 2024-12-03 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    @Override
    public Boolean removeVipPlateById (Long id) {
        return removeById(id);
    }

}
