package com.icetech.park.service.vip;

import com.icetech.db.mybatis.base.service.IBaseService;
import com.icetech.fee.domain.entity.vip.VipPlate;

/**
 * VIP车辆表 服务类
 *
 * Copyright (c) Department of Research and Development/Beijing
 * All Rights Reserved
 *
 * @author wanggang
 * @version 1.0 @date 2024-12-03
 */
public interface NewVipPlateService extends IBaseService<VipPlate> {

    /**
     * Description: 根据ID查询 VIP车辆表对象信息 <br>
     * Version1.0 2024-12-03 by wanggang创建
     *
     * @param id 对象id
     * @return VipPlate
     */
    VipPlate getVipPlateById (Long id);

    /**
     * Description: 新增  VIP车辆表对象信息 <br>
     * Version1.0 2024-12-03 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回新增后主键
     */
    Boolean addVipPlate (VipPlate entity);

    /**
     * Description: 修改 VIP车辆表对象信息 <br>
     * Version1.0 2024-12-03 by wanggang创建
     *
     * @param entity 对象信息
     * @return Boolean 返回更新后的结果
     */
    Boolean modifyVipPlate (VipPlate entity);

    /**
     * Description: 删除  VIP车辆表对象信息 <br>
     * Version1.0 2024-12-03 by wanggang创建
     *
     * @param id 对象id
     * @return Boolean 返回更新后的结果
     */
    Boolean removeVipPlateById (Long id);
}
