package com.icetech.park.service.video.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.api.ManageService;
import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.vo.ApplyCarVideoVo;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.order.domain.entity.OrderBack;
import com.icetech.order.domain.entity.OrderNotpay;
import com.icetech.order.service.OrderBackService;
import com.icetech.order.service.OrderNotpayService;
import com.icetech.oss.OssService;
import com.icetech.park.domain.entity.park.ParkRecovery;
import com.icetech.park.domain.vo.EvidenceVideoVO;
import com.icetech.park.service.park.ParkRecoveryService;
import com.icetech.park.service.video.EvidenceVideoService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;

@Service
public class EvidenceVideoServiceImpl implements EvidenceVideoService {

    @Autowired
    private OrderNotpayService orderNotpayService;
    @Autowired
    private OrderBackService orderBackService;
    @Autowired
    private ParkRecoveryService parkRecoveryService;
    @Autowired
    private OssService ossService;
    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ManageService manageService;
    @Autowired
    private ParkService parkService;

    /**
     * 获取视频 
     * @param type
     * @param id
     * @return
     */
    @Override
    public ObjectResponse<EvidenceVideoVO> evidenceVideo(Integer type, Long id) {
        LocalDate sevenDays = LocalDate.now().minusDays(6L);
        EvidenceVideoVO vo = EvidenceVideoVO.builder().videoUrl("").build();
        Long parkId = null;
        String url = "";
        String videoId = null;
        String plateNum = null;
        Long recTime = null;
        String orderNum = null;
        Long channelId = null;
        LocalDate createDate = null;
        // 1：跟车视频
        if (type == 1) {
            OrderNotpay notPay = orderNotpayService.getOrderNotpayById(id);
            if (notPay == null) {
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_402);
            }
            parkId = notPay.getParkId();
            LocalDateTime createTime = DateUtil.toLocalDateTime(notPay.getCreateTime());
            createDate = createTime.toLocalDate();
            url = notPay.getEvidenceVideo();
            videoId = notPay.getVideoId();
            plateNum = notPay.getPlateNum();
            recTime = notPay.getExitTime();
            orderNum = notPay.getOrderNum();
            channelId = notPay.getChannelId();
        }
        if (type ==2 ) {
            OrderBack orderBack = orderBackService.getOrderBackById(id);
            if (orderBack == null) {
                return ObjectResponse.failed(CodeConstantsEnum.ERROR_402);
            }
            parkId = orderBack.getParkId();
            LocalDateTime createTime = DateUtil.toLocalDateTime(orderBack.getCreateTime());
            createDate = createTime.toLocalDate();
            url = orderBack.getEvidenceVideo();
            videoId = orderBack.getVideoId();
            plateNum = orderBack.getPlateNum();
            recTime = orderBack.getExitTime() == null ? orderBack.getBackStartTime() : orderBack.getExitTime();
            orderNum = orderBack.getOrderNum();
            channelId = orderBack.getChannelId();
        }
        vo.setPlateNum(plateNum);
        if (channelId != null) {
            ObjectResponse<ParkInoutdevice> objectResponse = parkService.getInoutDeviceById(channelId);
            if (ObjectResponse.isSuccess(objectResponse)) {
                vo.setChannelName(objectResponse.getData().getInandoutName());
            }
        }
        ParkRecovery parkRecovery = parkRecoveryService.getParkRecoveryByParkId(parkId);
        if (parkRecovery == null) {
            vo.setIsOpenRecovery(0);
            return ObjectResponse.success(vo);
        }
        Date currentDate = new Date();
        if (DateUtil.compare(currentDate, DateUtil.parse(parkRecovery.getStartTime())) < 0) {
            vo.setIsOpenRecovery(0);
            return ObjectResponse.success(vo);
        }
        // 服务开通
        if (DateUtil.compare(currentDate, DateUtil.parse(parkRecovery.getStartTime())) >= 0 && DateUtil.compare(currentDate, DateUtil.offsetDay(DateUtil.parse(parkRecovery.getEndTime()), 1)) < 0) {
            vo.setIsOpenRecovery(1);
        }else {
            vo.setIsOpenRecovery(0);
            DateTime endTime = DateUtil.parse(parkRecovery.getEndTime());
            LocalDate endLocalDate = DateUtil.toLocalDateTime(endTime).toLocalDate();
            LocalDate now = LocalDate.now();
            long between = ChronoUnit.DAYS.between(endLocalDate, now);
            vo.setTimeOutDays(Math.toIntExact(between));
            return ObjectResponse.success(vo);
        }

        // 监控相机
        ObjectResponse<List<ParkDevice>> deviceObj = parkDeviceService.getDeviceListByChannelId(channelId, 9);
        if (StringUtils.isNotEmpty(url) || ObjectResponse.isSuccess(deviceObj)) {
            vo.setHasMorCamera(1);
        }else {
            vo.setHasMorCamera(0);
            return ObjectResponse.success(vo);
        }
        // 超过7天了
        if (createDate != null && (createDate.isAfter(sevenDays) || createDate.isEqual(sevenDays))){
            vo.setVideoExpire(0);
            // 视频地址为
            if (StringUtils.isNotEmpty(url) && ossService.isExistFile(url)) {
                String imageUrl = ossService.getImageUrl(url);
                if (StringUtils.isNotEmpty(imageUrl)) {
                    vo.setVideoUrl(imageUrl);
                }
            } else {
                ApplyCarVideoVo applyCarVideoVo = new ApplyCarVideoVo();
                applyCarVideoVo.setPlateNum(plateNum);
                applyCarVideoVo.setRecTime(recTime);
                applyCarVideoVo.setVideoType(type);
                applyCarVideoVo.setVideoId(videoId);
                applyCarVideoVo.setParkId(parkId);
                applyCarVideoVo.setOrderNum(orderNum);
                applyCarVideoVo.setChannelId(channelId);
                try {
                    ObjectResponse<String> objectResponse = manageService.applyCarVideo(applyCarVideoVo);
                    if (ObjectResponse.isSuccess(objectResponse)) {
                        vo.setVideoUrl(ossService.getImageUrl(objectResponse.getData()));
                    }
                }catch (Exception e) {
                    return ObjectResponse.success(vo);
                }
            }
        }else {
            vo.setVideoExpire(1);
        }
        return ObjectResponse.success(vo);
    }
}
