package com.icetech.park.service.vehicle;

import com.icetech.cloudcenter.api.user.VehicleService;
import com.icetech.park.dao.vehicle.VehicleOperDao;
import com.icetech.park.dao.vehicle.VehiclePlateDao;
import com.icetech.park.domain.entity.vehicle.VehicleOper;
import com.icetech.park.domain.entity.vehicle.VehiclePlate;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("vehicleService")
public class VehicleServiceImpl implements VehicleService {

    @Autowired
    private VehiclePlateDao vehiclePlateDao;
    @Autowired
    private VehicleOperDao vehicleOperDao;

    @Override
    public ObjectResponse<VehicleOper> selectOperById(Long id) {
        VehicleOper vehicleOper = vehicleOperDao.selectById(id);
        if (vehicleOper == null){
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }else{
            return ObjectResponse.success(vehicleOper);
        }
    }

    @Override
    public ObjectResponse<VehiclePlate> selectPlate(Integer relId, String plateNum) {
        VehiclePlate vehiclePlate = vehiclePlateDao.select(relId, plateNum);
        if (vehiclePlate == null){
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }else{
            return ObjectResponse.success(vehiclePlate);
        }
    }

    @Override
    public ObjectResponse<VehiclePlate> selectVip(Long parkId, String plateNum) {
        VehiclePlate vehiclePlate = vehiclePlateDao.selectVip(parkId, plateNum);
        if (vehiclePlate == null){
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }else{
            return ObjectResponse.success(vehiclePlate);
        }
    }
}
