package com.icetech.park.service.sms;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import com.github.pagehelper.Page;
import com.icetech.cloudcenter.domain.PageResult;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.db.utils.PageHelperUtils;
import com.icetech.park.dao.sms.SmsAlarmTemplateDao;
import com.icetech.park.domain.dto.sms.SmsAlarmTemplateDto;
import com.icetech.park.domain.entity.sms.SmsAlarmOrder;
import com.icetech.park.domain.entity.sms.SmsAlarmTemplate;
import com.icetech.park.domain.request.sms.SmsAlarmTemplateParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Slf4j
@Service
public class SmsAlarmTemplateService extends BaseServiceImpl<SmsAlarmTemplateDao, SmsAlarmTemplate> {
    /**
     * @return <{type}, {SmsAlarmTemplate}>
     */
    public Map<Integer, SmsAlarmTemplate> defMap() {
        return defList().stream().collect(Collectors.toMap(SmsAlarmTemplate::getType, Function.identity()));
    }

    public List<SmsAlarmTemplate> defList() {
        return getListByPark(0L);
    }

    public List<SmsAlarmTemplate> getListByPark(Long parkId) {
        return lambdaQuery().eq(SmsAlarmTemplate::getParkId, parkId).list();
    }

    public SmsAlarmTemplate getDefByType(int type) {
        return getByType(0, type);
    }

    public SmsAlarmTemplate getByType(long parkId, int type) {
        return lambdaQuery().eq(SmsAlarmTemplate::getParkId, parkId).eq(SmsAlarmTemplate::getType, type).one();
    }

    public PageResult<SmsAlarmTemplateDto> pageDto(SmsAlarmTemplateParam param) {
        Page<SmsAlarmTemplateDto> page = PageHelperUtils.page(param.getPageIndex(), param.getPageSize(),
                () -> getBaseMapper().getDtoList(param));
        return PageResult.fromPages(page);
    }

    @Transactional
    public boolean initTemplate(SmsAlarmOrder order) {
        List<SmsAlarmTemplate> templates = defList();
        for (SmsAlarmTemplate template : templates) {
            template.setId(null)
                    .setParkId(order.getParkId())
                    .setName("0")
                    .setContent("0")
                    .setTemplateCode(template.getTemplateCode())
                    .setCreateTime(LocalDateTime.now())
                    .setUpdateTime(LocalDateTime.now())
                    .setUpdateUser(order.getCreateUser());
        }
        return saveBatch(templates);
    }
}
