package com.icetech.park.service.sms;

import com.github.pagehelper.Page;
import com.icetech.cloudcenter.domain.PageResult;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.db.utils.PageHelperUtils;
import com.icetech.park.dao.sms.SmsAlarmSendRecordDao;
import com.icetech.park.domain.dto.sms.SmsAlarmSendRecordDto;
import com.icetech.park.domain.entity.sms.SmsAlarmSendRecord;
import com.icetech.park.domain.request.sms.SmsAlarmSendRecordParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class SmsAlarmSendRecordService extends BaseServiceImpl<SmsAlarmSendRecordDao, SmsAlarmSendRecord> {
    public PageResult<SmsAlarmSendRecordDto> pageDto(SmsAlarmSendRecordParam param) {
        Page<SmsAlarmSendRecordDto> page = PageHelperUtils.page(param.getPageIndex(), param.getPageSize(),
                () -> getBaseMapper().getDtoList(param));
        return PageResult.fromPages(page);
    }
}
