package com.icetech.park.service.sms;

import javax.annotation.Resource;

import com.icetech.park.dao.sms.SmsAlarmRuleDeviceDao;
import com.icetech.park.domain.entity.sms.SmsAlarmRuleDevice;
import com.icetech.park.domain.entity.sms.SmsAlarmRulePncCenter;
import com.icetech.park.domain.entity.sms.SmsAlarmRulePncCharge;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Slf4j
@Service
public class SmsAlarmRuleDeviceService extends SmsAlarmRuleBaseOfflineService<SmsAlarmRuleDeviceDao, SmsAlarmRuleDevice> {
    @Resource
    private SmsAlarmRulePncCenterService smsAlarmRulePncCenterService;
    @Resource
    private SmsAlarmRulePncChargeService smsAlarmRulePncChargeService;

    @Override
    @Transactional
    public boolean saveOrUpdateByParkId(SmsAlarmRuleDevice param) {
        param.setId(null);
        boolean result = super.saveOrUpdateByParkId(param);
        if (result && param.getId() != null) {  // id不为空表示新增
            // 新增/初始化时同步配置至端网云发送配置
            SmsAlarmRulePncCenter existsCenter = smsAlarmRulePncCenterService.getByParkId(param.getParkId());
            if (existsCenter == null) {
                SmsAlarmRulePncCenter center = new SmsAlarmRulePncCenter();
                BeanUtils.copyProperties(param, center);
                result = smsAlarmRulePncCenterService.saveWithCreate(center);
            }
            SmsAlarmRulePncCharge existsCharge = smsAlarmRulePncChargeService.getByParkId(param.getParkId());
            if (existsCharge == null) {
                SmsAlarmRulePncCharge charge = new SmsAlarmRulePncCharge();
                BeanUtils.copyProperties(param, charge);
                result = smsAlarmRulePncChargeService.saveWithCreate(charge);
            }
        }
        return result;
    }
}
