package com.icetech.park.service.sms;

import java.time.LocalDateTime;

import com.icetech.db.mybatis.base.mapper.SuperMapper;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.domain.entity.sms.SmsAlarmRuleBase;
import org.springframework.transaction.annotation.Transactional;

public class SmsAlarmRuleBaseService<M extends SuperMapper<T>, T extends SmsAlarmRuleBase> extends BaseServiceImpl<M, T> {
    public T getByParkId(Long parkId) {
        return lambdaQuery().eq(T::getParkId, parkId).one();
    }

    public T getDefault(Long parkId) {
        return lambdaQuery().eq(T::getParkId, parkId).one();
    }

    @Transactional
    public boolean saveOrUpdateByParkId(T param) {
        T exists = getByParkId(param.getParkId());
        if (exists == null) {
            param.setCreateTime(LocalDateTime.now());
            return saveWithCreate(param);
        } else {
            return updateByParkId(param);
        }
    }

    public boolean saveWithCreate(T param) {
        param.setId(null)
                .setCreateTime(LocalDateTime.now())
                .setUpdateTime(LocalDateTime.now());
        return save(param);
    }

    public boolean updateByParkId(T param) {
        Long id = param.getId(), parkId = param.getParkId();
        param.setId(null).setParkId(null)
                .setUpdateTime(LocalDateTime.now());
        boolean result = lambdaUpdate()
                .eq(T::getParkId, parkId)
                .update(param);
        param.setId(id).setParkId(parkId);
        return result;
    }
}
