package com.icetech.park.service.sms;

import java.util.List;

import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.sms.SmsAlarmProductDao;
import com.icetech.park.domain.constant.sms.SmsAlarmProductConsts;
import com.icetech.park.domain.entity.sms.SmsAlarmProduct;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class SmsAlarmProductService extends BaseServiceImpl<SmsAlarmProductDao, SmsAlarmProduct> {
    public List<SmsAlarmProduct> getAllEnabled() {
        return lambdaQuery().eq(SmsAlarmProduct::getEnableFlag, SmsAlarmProductConsts.ENABLE_FLAG_YES)
                .orderByAsc(SmsAlarmProduct::getSmsCount)
                .last("limit 100").list();
    }
}
