package com.icetech.park.service.sms;

import java.time.LocalDateTime;

import javax.annotation.Resource;

import com.github.pagehelper.Page;
import com.icetech.cloudcenter.domain.PageResult;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.db.utils.PageHelperUtils;
import com.icetech.park.dao.sms.SmsAlarmOrderDao;
import com.icetech.park.domain.dto.sms.SmsAlarmOrderDto;
import com.icetech.park.domain.entity.sms.SmsAlarmOrder;
import com.icetech.park.domain.request.sms.SmsAlarmOrderParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Slf4j
@Service
public class SmsAlarmOrderService extends BaseServiceImpl<SmsAlarmOrderDao, SmsAlarmOrder> {
    public static final String PAYMENT_KEY = "sms_alarm:payment:";
    @Resource
    private SmsAlarmConfigService smsAlarmConfigService;

    public PageResult<SmsAlarmOrderDto> pageDto(SmsAlarmOrderParam param) {
        Page<SmsAlarmOrderDto> page = PageHelperUtils.page(param.getPageIndex(), param.getPageSize(),
                () -> getBaseMapper().getDtoList(param));
        return PageResult.fromPages(page);
    }

    public SmsAlarmOrder sumSmsCountAndAmount(SmsAlarmOrderParam param) {
        return getBaseMapper().sumSmsCountAndAmount(param);
    }

    public SmsAlarmOrder getByOrderNum(String orderNum) {
        return lambdaQuery().eq(SmsAlarmOrder::getOrderNum, orderNum).one();
    }

    @Transactional
    public void paid(SmsAlarmOrder order) {
        SmsAlarmOrder exists = getByOrderNum(order.getOrderNum());
        if (exists != null) {
            log.warn("短信服务购买通知|忽略重复通知|{}", order);
            return;
        }
        order.setId(null)
                .setPayChannel(1)
                .setCreateTime(LocalDateTime.now());
        save(order);
        smsAlarmConfigService.saveOrUpdate(order);
    }
}
