package com.icetech.park.service.sms;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.icetech.cloudcenter.domain.PageResult;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import com.icetech.park.dao.sms.SmsAlarmOperRecordDao;
import com.icetech.park.domain.entity.sms.SmsAlarmOperRecord;
import com.icetech.park.domain.request.sms.SmsAlarmOperRecordParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class SmsAlarmOperRecordService extends BaseServiceImpl<SmsAlarmOperRecordDao, SmsAlarmOperRecord> {
    public PageResult<SmsAlarmOperRecord> page(SmsAlarmOperRecordParam param) {
        Page<SmsAlarmOperRecord> page = new Page<>(param.getPageIndex(), param.getPageSize());
        page = lambdaQuery().eq(param.getParkId() != null, SmsAlarmOperRecord::getParkId, param.getParkId())
                .eq(param.getModuleType() != null, SmsAlarmOperRecord::getModuleType, param.getModuleType())
                .in(CollectionUtils.isNotEmpty(param.getModuleTypes()), SmsAlarmOperRecord::getModuleType, param.getModuleTypes())
                .in(!param.getPermitParkIds().contains(-1L), SmsAlarmOperRecord::getParkId, param.getPermitParkIds())
                .orderByDesc(SmsAlarmOperRecord::getOperTime)
                .page(page);
        return PageResult.fromPage(page);
    }
}
