package com.icetech.park.service.shanghai.impl;

import com.alibaba.csp.sentinel.annotation.SentinelResource;
import com.icetech.cloudcenter.api.third.ShService;
import com.icetech.third.anno.DS_SLAVE;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.sentinel.ExceptionUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

@Service
@Slf4j
public class ShangHaiServiceImpl implements ShService {

    @Autowired
    private OrderInfoDao orderInfoDao;

    @Override
    @DS_SLAVE
    @SentinelResource(value = "ShangHaiService.getEnterReRecords", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public Integer getEnterReRecords(Park park) {
        Calendar calendar = new GregorianCalendar();
        calendar.add(Calendar.DAY_OF_MONTH,0);
        calendar.set(Calendar.HOUR_OF_DAY,0);
        calendar.set(Calendar.MINUTE,0);
        calendar.set(Calendar.SECOND,0);
        calendar.set(Calendar.MILLISECOND,0);
        Date dayStart = calendar.getTime();
        long starttime = dayStart.getTime()/1000;
        long endtime = new Date().getTime()/1000;
        return orderInfoDao.countEnterRecords(String.valueOf(park.getId()), starttime, endtime, null, null,null);
    }

    @Override
    @DS_SLAVE
    @SentinelResource(value = "ShangHaiService.getExitReRecords", defaultFallback = "defaultFallbackHandle", fallbackClass = {ExceptionUtils.class})
    public Integer getExitReRecords(Park park) {
        Calendar calendar = new GregorianCalendar();
        calendar.add(Calendar.DAY_OF_MONTH,0);
        calendar.set(Calendar.HOUR_OF_DAY,0);
        calendar.set(Calendar.MINUTE,0);
        calendar.set(Calendar.SECOND,0);
        calendar.set(Calendar.MILLISECOND,0);
        Date dayStart = calendar.getTime();
        long starttime = dayStart.getTime()/1000;
        long endtime = new Date().getTime()/1000;
        return orderInfoDao.countExitRecords(String.valueOf(park.getId()), starttime, endtime, null, null,null,null, null);
    }

}
