package com.icetech.park.service.runso;

import com.sun.jna.Library;
import com.sun.jna.Native;

public interface Clibrary extends Library {
    // [Native.synchronizedLibrary] 阻止多线程同时访问本地代码
    Clibrary INSTANTCE = (Clibrary) Native.synchronizedLibrary(
            (Clibrary) Native.loadLibrary("ice_pimscharge"
                    , Clibrary.class
            )
    );

    /**
     * 让C++查库计费
     *
     * @param tmEntry
     * @param tmExit
     * @param tmDiscount
     * @param chargeflag
     * @param cartype
     * @param billId
     * @param db_server
     * @param db_username
     * @param db_password
     * @return
     */
    float chargeinterface_db(int tmEntry, int tmExit, int tmDiscount, int chargeflag, int cartype,
                             int parkId, int billId, String db_server, String db_username, String db_password);

    /**
     * 让C++查库计费
     *
     * @param tmEntry
     * @param tmExit
     * @param tmDiscount
     * @param chargeflag
     * @param cartype
     * @param billId
     * @param db_server
     * @param db_username
     * @param db_password
     * @param isUseFreetime 是否使用免费时长，0：使用，1：不使用
     * @return
     */
    float chargeinterface_db_freetime(int tmEntry, int tmExit, int tmDiscount, int chargeflag, int cartype,
                                      int parkId, int billId, String db_server, String db_username,
                                      String db_password, int isUseFreetime);

    /**
     * 让C++查库计费
     *
     * @param tmEntry
     * @param tmExit
     * @param tmDiscount
     * @param chargeflag
     * @param cartype
     * @param billId
     * @param db_server
     * @param db_username
     * @param db_password
     * @param csFeeType
     * @param csSwitchTime
     * @return
     */
    float chargeinterface_time_db(int tmEntry, int tmExit, int tmDiscount, int chargeflag, int cartype,
                                  int parkId, int billId, String db_server, String db_username, String db_password,
                                  String cPartBegin, String cPartEnd, int csFeeType, int csSwitchTime);

    float chargeinterface_time_db_freetime(int tmEntry, int tmExit, int tmDiscount, int chargeflag, int cartype,
                                           int parkId, int billId, String db_server, String db_username, String db_password,
                                           String cPartBegin, String cPartEnd, int csFeeType, int csSwitchTime, int isUseFreetime);

    /**
     * 函数名称：chargeinterface
     * 函数功能：临时车计费接口
     *
     * @param tmEntry        计费开始时间（秒）
     * @param tmExit         计费结束时间（秒）
     * @param tmDiscount     优惠时长（分钟）
     * @param chargeflag     是否首次缴费标识（0：首次，1：非首次）
     * @param cartype        车类型（1：小型车，2：大型车）
     * @param chChargeConfig 计费配置
     * @param chChargeRule   计费规则
     * @param isusefreetime  是否使用免费时长（0：使用，1：不使用）
     * @return 大于等于0:成功, 小于0:错误
     */
    float chargeinterface_json(int tmEntry, int tmExit, int tmDiscount, int chargeflag, int cartype,
                               String chChargeConfig, String chChargeRule, int isusefreetime);

    /**
     * 函数名称：chargeinterface_time
     * 函数功能：错时车计费接口
     *
     * @param tmEntry        计费开始时间（秒）
     * @param tmExit         计费结束时间（秒）
     * @param tmDiscount     优惠时长（分钟）
     * @param chargeflag     是否首次缴费标识（0：首次，1：非首次）
     * @param cartype        车类型（0：小型车，1：大型车）
     * @param chChargeConfig 计费配置
     * @param chChargeRule   计费规则
     * @param cPartBegin     错时开始时间
     * @param cPartEnd       错时结束时间
     * @param changetype     错时切换类型（0：错时车，1：错时车转临时车，2：临时车转错时车）
     * @param tmChange       错时切换时间
     * @param isusefreetime  是否使用免费时长（0：使用，1：不使用）
     * @return 大于等于0:成功, 小于0:错误
     */
    float chargeinterface_time_json(int tmEntry, int tmExit, int tmDiscount, int chargeflag, int cartype,
                                    String chChargeConfig, String chChargeRule, String cPartBegin, String cPartEnd,
                                    int changetype, int tmChange, int isusefreetime);
}
