package com.icetech.park.service.report.pnc.impl;

import java.time.LocalTime;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.config.GrayProperties;
import com.icetech.park.domain.entity.lcd.LcdBrightness;
import com.icetech.park.domain.entity.lcd.LcdConfig;
import com.icetech.park.domain.entity.lcd.LcdShow;
import com.icetech.park.domain.entity.lcd.LcdSound;
import com.icetech.park.domain.entity.lcd.LcdSoundcode;
import com.icetech.park.domain.entity.lcd.LcdTips;
import com.icetech.park.domain.entity.led.LedShow;
import com.icetech.park.domain.entity.led.LedConfig;
import com.icetech.park.domain.entity.led.LedSound;
import com.icetech.park.domain.entity.led.LedTips;
import com.icetech.park.domain.entity.park.ParkGuide;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.VoiceScreenUpRequest;
import com.icetech.cloudcenter.domain.request.pnc.VoiceScreenUpRequest.LcdBrightnessInfo;
import com.icetech.cloudcenter.domain.request.pnc.VoiceScreenUpRequest.LcdDetailInfo;
import com.icetech.cloudcenter.domain.request.pnc.VoiceScreenUpRequest.LcdShowInfo;
import com.icetech.cloudcenter.domain.request.pnc.VoiceScreenUpRequest.LcdSoundCodeInfo;
import com.icetech.cloudcenter.domain.request.pnc.VoiceScreenUpRequest.LcdSoundInfo;
import com.icetech.cloudcenter.domain.request.pnc.VoiceScreenUpRequest.LcdTipsInfo;
import com.icetech.cloudcenter.domain.request.pnc.VoiceScreenUpRequest.LedConfigInfo;
import com.icetech.cloudcenter.domain.request.pnc.VoiceScreenUpRequest.LedDetailInfo;
import com.icetech.cloudcenter.domain.request.pnc.VoiceScreenUpRequest.LedSoundConfigInfo;
import com.icetech.cloudcenter.domain.request.pnc.VoiceScreenUpRequest.LedSpecialInfo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.lcd.LcdBrightnessServiceImpl;
import com.icetech.park.service.lcd.LcdConfigServiceImpl;
import com.icetech.park.service.lcd.LcdShowServiceImpl;
import com.icetech.park.service.lcd.LcdSoundServiceImpl;
import com.icetech.park.service.lcd.LcdSoundcodeServiceImpl;
import com.icetech.park.service.lcd.LcdTipsServiceImpl;
import com.icetech.park.service.ledsound.LedShowServiceImpl;
import com.icetech.park.service.ledsound.LedConfigServiceImpl;
import com.icetech.park.service.ledsound.LedSoundServiceImpl;
import com.icetech.park.service.ledsound.LedTipsServiceImpl;
import com.icetech.park.service.park.impl.ParkGuideServiceImpl;
import com.icetech.third.service.third.SendInfoServiceImpl;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.transaction.annotation.Transactional;

@Slf4j
//@Service
public class VoiceScreenUpServiceImpl extends AbstractService implements ReportService {
    @Autowired
    private LedConfigServiceImpl ledSoundConfigService;
    @Autowired
    private LedShowServiceImpl ledService;
    @Autowired
    private LedSoundServiceImpl soundService;
    @Autowired
    private LedTipsServiceImpl specialLedService;
    @Autowired
    private LcdConfigServiceImpl lcdConfigService;
    @Autowired
    private LcdBrightnessServiceImpl lcdBrightnessService;
    @Autowired
    private LcdShowServiceImpl lcdShowService;
    @Autowired
    private LcdTipsServiceImpl lcdTipsService;
    @Autowired
    private LcdSoundcodeServiceImpl lcdSoundcodeService;
    @Autowired
    private LcdSoundServiceImpl lcdSoundService;
    @Autowired
    private ParkGuideServiceImpl parkGuideService;
    @Autowired
    private SendInfoServiceImpl sendInfoService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private GrayProperties grayProperties;

    @Override
    @Transactional
    public ObjectResponse report(DataCenterBaseRequest baseRequest, Long parkId) throws Exception {
        if (baseRequest.getBizContent() == null) return ObjectResponse.failed(CodeConstantsEnum.ERROR_400);
        VoiceScreenUpRequest request = JSON.parseObject(JSON.toJSONString(baseRequest.getBizContent()), VoiceScreenUpRequest.class);
        if (request == null || request.getType() == null) return ObjectResponse.failed(CodeConstantsEnum.ERROR_400);
        if (request.getType() == 1) {
//            return handleLed(parkId, request.getDetailInfo().toJavaObject(LedDetailInfo.class));
        } else if (request.getType() == 2) {
//            return handleLcd(parkId, request.getDetailInfo().toJavaObject(LcdDetailInfo.class));
        } else {
            throw new ResponseBodyException(CodeConstants.ERROR_400, "未知类型: " + request.getType());
        }
        return null;
    }

    private ObjectResponse<Boolean> handleLed(long parkId, LedDetailInfo info) {
        LedConfig config = buildLedSoundConfig(parkId, info);
        if (CollectionUtils.isEmpty(info.getLedConfig()))
            return ObjectResponse.failed(CodeConstants.ERROR_400, "缺少LED屏显配置");
        if (CollectionUtils.isEmpty(info.getSoundConfig()))
            return ObjectResponse.failed(CodeConstants.ERROR_400, "缺少LED语音配置");
        if (CollectionUtils.isEmpty(info.getLedSpecial()))
            return ObjectResponse.failed(CodeConstants.ERROR_400, "缺少LED屏显特殊配置");

        List<LedShow> ledShowConfigs = info.getLedConfig().stream().map(ledConfigInfo -> buildLedConfig(parkId, ledConfigInfo)).collect(Collectors.toList());
        List<LedSound> ledLedSounds = info.getSoundConfig().stream().map(ledSoundConfigInfo -> buildLedSound(parkId, ledSoundConfigInfo)).collect(Collectors.toList());
        List<LedTips> ledSpecials = info.getLedSpecial().stream().map(ledSpecialInfo -> buildLedSpecial(parkId, ledSpecialInfo)).collect(Collectors.toList());

        ledSoundConfigService.remove(Wrappers.lambdaQuery(LedConfig.class).eq(LedConfig::getParkId, parkId));
        ledService.remove(Wrappers.lambdaQuery(LedShow.class).eq(LedShow::getParkId, parkId));
        soundService.remove(Wrappers.lambdaQuery(LedSound.class).eq(LedSound::getParkId, parkId));
        specialLedService.remove(Wrappers.lambdaQuery(LedTips.class).eq(LedTips::getParkId, parkId));
        ledSoundConfigService.save(config);
        ledService.saveBatch(ledShowConfigs);
        soundService.saveBatch(ledLedSounds);
        specialLedService.saveBatch(ledSpecials);
        ParkGuide guide = new ParkGuide();
        guide.setParkId(parkId);
        guide.setStep5(1);
        parkGuideService.updateByParkId(guide);
        sendInfoService.save(SendInfo.buildUnneeded(parkId, parkId, DownServiceEnum.LED语音屏显.getServiceType(), "本地上报"));

        List<String> deleteKeys = new LinkedList<>();
        deleteKeys.add(RedisKeyConstants.KEY_PREFIX_LED_CONFIG_PARK + parkId);
        deleteKeys.add(RedisKeyConstants.KEY_PREFIX_LED_SHOW_PARK + parkId);
        deleteKeys.add(RedisKeyConstants.KEY_PREFIX_LED_SOUND_PARK + parkId);
        deleteKeys.add(RedisKeyConstants.KEY_PREFIX_LED_TIPS_PARK + parkId);
        if (grayProperties.isCacheEnable()) {
            deleteKeys.add(RedisKeyConstants.KEY_PREFIX_GRAY + RedisKeyConstants.KEY_PREFIX_LED_CONFIG_PARK + parkId);
            deleteKeys.add(RedisKeyConstants.KEY_PREFIX_GRAY + RedisKeyConstants.KEY_PREFIX_LED_SHOW_PARK + parkId);
            deleteKeys.add(RedisKeyConstants.KEY_PREFIX_GRAY + RedisKeyConstants.KEY_PREFIX_LED_SOUND_PARK + parkId);
            deleteKeys.add(RedisKeyConstants.KEY_PREFIX_GRAY + RedisKeyConstants.KEY_PREFIX_LED_TIPS_PARK + parkId);
        }
        stringRedisTemplate.delete(deleteKeys);
        return ObjectResponse.success();
    }

    private ObjectResponse<Boolean> handleLcd(long parkId, long channelId, LcdDetailInfo info) {
        if (CollectionUtils.isEmpty(info.getLcdBrightness()))
            return ObjectResponse.failed(CodeConstants.ERROR_400, "缺少LCD屏显亮度配置");
        if (CollectionUtils.isEmpty(info.getLcdShow()))
            return ObjectResponse.failed(CodeConstants.ERROR_400, "缺少LCD屏显每行配置");
        if (CollectionUtils.isEmpty(info.getLcdTips()))
            return ObjectResponse.failed(CodeConstants.ERROR_400, "缺少LCD进出场提示配置");
//        if(CollectionUtils.isEmpty(info.getLcdSoundcode()))
//            return ObjectResponse.failed(CodeConstants.ERROR_400, "缺少LCD语音编码配置");
        if (CollectionUtils.isEmpty(info.getLcdSound()))
            return ObjectResponse.failed(CodeConstants.ERROR_400, "缺少LCD语音配置");

        LcdConfig lcdConfig = buildLcdConfig(parkId, info);
        List<LcdShow> lcdShows = info.getLcdShow().stream().map(lcdShowInfo -> buildLcdShow(parkId, lcdShowInfo)).collect(Collectors.toList());
        List<LcdTips> lcdTipses = info.getLcdTips().stream().map(lcdTipsInfo -> buildLcdTips(parkId, lcdTipsInfo)).collect(Collectors.toList());
//        List<LcdSoundcode> lcdSoundCodes = info.getLcdSoundcode().stream().map(this::buildLcdSoundCode).collect(Collectors.toList());
        List<LcdSound> lcdSounds = info.getLcdSound().stream().map(lcdSoundInfo -> buildLcdSound(parkId, lcdSoundInfo)).collect(Collectors.toList());

        List<LcdConfig> existsLcdConfigs = lcdConfigService.list(Wrappers.lambdaQuery(LcdConfig.class).eq(LcdConfig::getParkId, parkId));
        if (!existsLcdConfigs.isEmpty()) {
            lcdConfigService.remove(Wrappers.lambdaQuery(LcdConfig.class).eq(LcdConfig::getParkId, parkId));
            lcdBrightnessService.remove(Wrappers.lambdaQuery(LcdBrightness.class).in(LcdBrightness::getLcdId, existsLcdConfigs.stream().map(LcdConfig::getId).collect(Collectors.toList())));
        }
        lcdShowService.remove(Wrappers.lambdaQuery(LcdShow.class).eq(LcdShow::getParkId, parkId));
        lcdTipsService.remove(Wrappers.lambdaQuery(LcdTips.class).eq(LcdTips::getParkId, parkId));
//        lcdSoundcodeService.remove(Wrappers.lambdaQuery(LcdSoundcode.class).eq(LcdSoundcode::getParkId, parkId));
        lcdSoundService.remove(Wrappers.lambdaQuery(LcdSound.class).eq(LcdSound::getParkId, parkId));

        lcdConfigService.save(lcdConfig);
        List<LcdBrightness> lcdBrightnesses = info.getLcdBrightness().stream().map(lcdBrightnessInfo -> buildLcdBrightness(lcdConfig.getId(), lcdBrightnessInfo)).collect(Collectors.toList());
        lcdBrightnessService.saveBatch(lcdBrightnesses);
        lcdShowService.saveBatch(lcdShows);
        lcdTipsService.saveBatch(lcdTipses);
//        lcdSoundcodeService.saveBatch(lcdSoundCodes);
        lcdSoundService.saveBatch(lcdSounds);
        ParkGuide guide = new ParkGuide();
        guide.setParkId(parkId);
        guide.setStep5(1);
        parkGuideService.updateByParkId(guide);
        sendInfoService.save(SendInfo.buildUnneeded(parkId, parkId, DownServiceEnum.LCD语音屏显.getServiceType(), "本地上报"));

        stringRedisTemplate.delete(Arrays.asList(
                RedisKeyConstants.KEY_PREFIX_LCD_CONFIG_CHANNEL + channelId,
                RedisKeyConstants.KEY_PREFIX_LCD_SHOW_CHANNEL + channelId,
                RedisKeyConstants.KEY_PREFIX_LCD_SOUND_CHANNEL + channelId,
                RedisKeyConstants.KEY_PREFIX_LCD_TIPS_CHANNEL + channelId
        ));
        return ObjectResponse.success();
    }

    private LedConfig buildLedSoundConfig(long parkId, LedDetailInfo info) {
        LedConfig config = new LedConfig();
        config.setParkId(parkId);
//        config.setStyle(info.getStyle());
        config.setLedLineNum(info.getLedLineNum());
        config.setLedRemainDaysMc(info.getLedRemainDaysMc());
        config.setLedExpireDaysMc(info.getLedExpireDaysMc());
//        config.setLedExpireDaysMonth(info.getLedExpireDaysMonth());
        config.setLedBlackCar(info.getLedBlackCar());
        config.setLedRestoreDefaultTime(info.getLedRestoreDefaultTime());
        config.setLedQrcodeRule(info.getLedQrcodeRule());
//        config.setLedQrcodeUrl(info.getLedQrcodeUrl());
        config.setVolumeValue(info.getVolumeValue());
        config.setQuietHoursSwitch(info.getQuietHoursSwitch());
        config.setQuietStartTime(LocalTime.parse(info.getQuietStartTime(), DateUtils.DEFAULT_TIME_FORMAT));
        config.setQuietEndTime(LocalTime.parse(info.getQuietEndTime(), DateUtils.DEFAULT_TIME_FORMAT));
        config.setQuietVolumeValue(info.getQuietVolumeValue());
        config.setLimitType(info.getLimitType());
        config.setLimitDriveNum1(info.getLimitDriveNum1());
        config.setLimitDriveNum2(info.getLimitDriveNum2());
        config.setLimitDriveNum3(info.getLimitDriveNum3());
        config.setLimitDriveNum4(info.getLimitDriveNum4());
        config.setLimitDriveNum5(info.getLimitDriveNum5());
//        config.setUpdateTime(info.getUpdateTime());
//        config.setUpdateUser(info.getUpdateUser());
        return config;
    }

    private LedShow buildLedConfig(long parkId, LedConfigInfo info) {
        LedShow ledShow = new LedShow();
        ledShow.setParkId(parkId);
        ledShow.setDisplayType(info.getDisplayType());
        ledShow.setRowNum(info.getRowNum());
        ledShow.setLedColor(info.getLedColor());
        ledShow.setDynamicContent(info.getDynamicContent());
        ledShow.setCustomContent(info.getCustomContent());
//        led.setUpdateTime(info.getUpdateTime());
//        led.setUpdateUser(info.getUpdateUser());
        return ledShow;
    }

    private LedSound buildLedSound(long parkId, LedSoundConfigInfo info) {
        LedSound ledSound = new LedSound();
        ledSound.setParkId(parkId);
        ledSound.setSoundType(info.getSoundType());
        ledSound.setDynamicContent(info.getDynamicContent());
        ledSound.setCustomContent(info.getCustomContent());
//        sound.setUpdateTime(info.getUpdateTime());
//        sound.setUpdateUser(info.getUpdateUser());
        return ledSound;
    }

    private LedTips buildLedSpecial(long parkId, LedSpecialInfo info) {
        LedTips special = new LedTips();
        special.setParkId(parkId);
        special.setEnterTmpSpecial(info.getEnterTmpSpecial());
        special.setEnterMonthVip(info.getEnterMonthVip());
        special.setEnterNotAllowTmpRun(info.getEnterNotAllowTmpRun());
        special.setEnterMultiParkCar(info.getEnterMultiParkCar());
        special.setEnterBlackCar(info.getEnterBlackCar());
        special.setEnterMonthExpire(info.getEnterMonthExpire());
        special.setEnterNoParkingSpace(info.getEnterNoParkingSpace());
        special.setEnterNotAllowNocarRun(info.getEnterNotAllowNocarRun());
        special.setExitPay(info.getExitPay());
        special.setExitOpenGate(info.getExitOpenGate());
        special.setExitNoEnterinfo(info.getExitNoEnterinfo());
        special.setExitNoCarplate(info.getExitNoCarplate());
        special.setExitNotAllowRun(info.getExitNotAllowRun());
//        special.setUpdateTime(info.getUpdateTime());
//        special.setUpdateUser(info.getUpdateUser());
        return special;
    }

    private LcdConfig buildLcdConfig(long parkId, LcdDetailInfo info) {
        LcdConfig config = new LcdConfig();
        config.setLineNum(info.getLineNum());
        config.setRemainDaysMc(info.getRemainDaysMc());
        config.setExpireDaysMc(info.getExpireDaysMc());
        config.setExpireDaysMonth(info.getExpireDaysMonth());
        config.setBlackCar(info.getBlackCar());
        config.setEntranceFreeLayout(info.getEntranceFreeLayout());
        config.setEnterLayout(info.getEnterLayout());
        config.setExitFreeLayout(info.getExitFreeLayout());
        config.setExitLayout(info.getExitLayout());
        config.setRestoreDefaultTime(info.getRestoreDefaultTime());
        config.setVolumeValue(info.getVolumeValue());
        config.setQuietHoursSwitch(info.getQuietHoursSwitch());
        config.setQuietStartTime(LocalTime.parse(info.getQuietStartTime(), DateUtils.DEFAULT_TIME_FORMAT));
        config.setQuietEndTime(LocalTime.parse(info.getQuietEndTime(), DateUtils.DEFAULT_TIME_FORMAT));
        config.setQuietVolumeValue(info.getQuietVolumeValue());
        config.setLimitType(info.getLimitType());
        config.setLimitDriveNum1(info.getLimitDriveNum1());
        config.setLimitDriveNum2(info.getLimitDriveNum2());
        config.setLimitDriveNum3(info.getLimitDriveNum3());
        config.setLimitDriveNum4(info.getLimitDriveNum4());
        config.setLimitDriveNum5(info.getLimitDriveNum5());
//        config.setUpdateTime(info.getUpdateTime());
//        config.setUpdateUser(info.getUpdateUser());
        config.setParkId(parkId);
        return config;
    }

    private LcdBrightness buildLcdBrightness(long lcdId, LcdBrightnessInfo info) {
        LcdBrightness brightness = new LcdBrightness();
        brightness.setLcdId(lcdId);
        brightness.setStartTimePoint(info.getStartTimePoint());
        brightness.setEndTimePoint(info.getEndTimePoint());
        brightness.setBrightnessVal(info.getBrightnessVal());
        brightness.setSort(info.getSort());
        return brightness;
    }

    private LcdShow buildLcdShow(long parkId, LcdShowInfo info) {
        LcdShow show = new LcdShow();
        show.setParkId(parkId);
        show.setDisplayType(info.getDisplayType());
        show.setRowNum(info.getRowNum());
        show.setRowColor(info.getRowColor());
        show.setDynamicContent(info.getDynamicContent());
        show.setCustomContent(info.getCustomContent());
//        show.setUpdateTime(info.getUpdateTime());
//        show.setUpdateUser(info.getUpdateUser());
        return show;
    }

    private LcdTips buildLcdTips(long parkId, LcdTipsInfo info) {
        LcdTips tips = new LcdTips();
        tips.setParkId(parkId);
        tips.setEnterTmpSpecial(info.getEnterTmpSpecial());
        tips.setEnterMonthVip(info.getEnterMonthVip());
        tips.setEnterNotAllowTmpRun(info.getEnterNotAllowTmpRun());
        tips.setEnterMultiParkCar(info.getEnterMultiParkCar());
        tips.setEnterBlackCar(info.getEnterBlackCar());
        tips.setEnterMonthExpire(info.getEnterMonthExpire());
        tips.setEnterNoParkingSpace(info.getEnterNoParkingSpace());
        tips.setEnterNotAllowNocarRun(info.getEnterNotAllowNocarRun());
        tips.setExitPay(info.getExitPay());
        tips.setExitOpenGate(info.getExitOpenGate());
        tips.setExitNoEnterinfo(info.getExitNoEnterinfo());
        tips.setExitNoCarplate(info.getExitNoCarplate());
        tips.setExitNotAllowRun(info.getExitNotAllowRun());
//        tips.setUpdateTime(info.getUpdateTime());
//        tips.setUpdateUser(info.getUpdateUser());
        return tips;
    }

    private LcdSoundcode buildLcdSoundCode(LcdSoundCodeInfo info) {
        LcdSoundcode code = new LcdSoundcode();
        code.setSoundCode(info.getSoundCode());
        code.setContent(info.getContent());
        code.setType(info.getType());
        code.setIsCustom(info.getIsCustom());
        code.setCustomSoundPath(info.getCustomSoundPath());
//        code.setCreateTime(info.getCreateTime());
//        code.setUpdateTime(info.getUpdateTime());
        return code;
    }

    private LcdSound buildLcdSound(long parkId, LcdSoundInfo info) {
        LcdSound sound = new LcdSound();
        sound.setParkId(parkId);
        sound.setSoundType(info.getSoundType());
        sound.setContentPattern(info.getContentPattern());
//        sound.setUpdateTime(info.getUpdateTime());
//        sound.setUpdateUser(info.getUpdateUser());
        return sound;
    }
}
