package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.order.OrderCarInfoService;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.DateTools;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.UploadFileRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.utils.RedisUtils;
import com.icetech.oss.OssService;
import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
@Slf4j
public class UploadFileServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private OssService ossService;
    @Autowired
    private OrderCarInfoService orderCarInfoService;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {

        UploadFileRequest uploadFileRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), UploadFileRequest.class);

        verifyParams(uploadFileRequest);

        String parkCode = dataCenterBaseRequest.getParkCode();

        String date = DateTools.getFormat(DateTools.DF_, new Date());
        String[] ymd = date.split("-");

        String imgFileName = parkCode + "/" + "image"
                + "/" + ymd[0] + ymd[1] + "/" + ymd[2] + "/"
                + uploadFileRequest.getFileName();
        ossService.uploadBase64(uploadFileRequest.getBase64Str(), imgFileName);
        log.info("<文件上传接口> 文件上传完成，文件名：{}", imgFileName);

        int fileType = uploadFileRequest.getFileType();
        String orderId = uploadFileRequest.getOrderId();
        if (orderId != null){
            String orderNum = publicHandle.convert2OrderNum(parkId, orderId);

            OrderCarInfo data = new OrderCarInfo();
            data.setOrderNum(orderNum);
            if(uploadFileRequest.getEnexType() == 1) {
                if (fileType == 1){
                    data.setEnterImage(imgFileName);
                }else{
                    data.setSmallEnterImage(imgFileName);
                }
            } else {
                if (fileType == 1){
                    data.setExitImage(imgFileName);
                }else{
                    data.setSmallExitImage(imgFileName);
                }
            }

            return orderCarInfoService.updateCarInfo(data);
        }else{
            redisUtils.set(RedisConstants.PNC_FILEID_PROFILE + parkCode + uploadFileRequest.getFileId(), imgFileName, 30L);
            return ObjectResponse.success();
        }
    }
}
