package com.icetech.park.service.report.pnc.impl;

import com.icetech.order.dao.ReportBclientDao;
import com.icetech.order.domain.entity.ReportBclient;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.TollCashCountRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;

@Service
public class TollCashCountServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private ReportBclientDao reportBclientDao;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {

        TollCashCountRequest tollCashCountRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), TollCashCountRequest.class);

        //参数校验
        verifyParams(tollCashCountRequest);

        /**
         * 开始处理业务
         */
        Date startTime = new Date(tollCashCountRequest.getStartTime() * 1000);
        Date endTime = new Date(tollCashCountRequest.getEndTime() * 1000);
        int i = reportBclientDao.selectByName(parkId, startTime, endTime, tollCashCountRequest.getCollectorName());
        if (i == 0){
            ReportBclient reportBclient = new ReportBclient();
            reportBclient.setParkId(parkId);
            reportBclient.setName(tollCashCountRequest.getCollectorName());
            reportBclient.setUsername(tollCashCountRequest.getUserAccount());
            reportBclient.setPayNum(tollCashCountRequest.getPayNum().intValue());
            reportBclient.setAmount(new BigDecimal(tollCashCountRequest.getCashTotal()));
            reportBclient.setRealcharge(new BigDecimal(tollCashCountRequest.getCashTotal()));
            reportBclient.setCharge(new BigDecimal(tollCashCountRequest.getCashTotal()));
            reportBclient.setDisamount(new BigDecimal("0.00"));
            reportBclient.setStartTime(startTime);
            reportBclient.setEndTime(endTime);
            reportBclient.setType(1);
            reportBclientDao.insert(reportBclient);
        }
        return ObjectResponse.success();
    }

}
