package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.order.OrderSimpleExitService;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.request.SimpleExitRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.park.service.report.pnc.AbstractExitService;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service
public class SimpleExitServiceImpl extends AbstractExitService implements ReportService {

    @Autowired
    private OrderSimpleExitService orderSimpleExitService;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        SimpleExitRequest exitRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), SimpleExitRequest.class);

        //参数校验
        verifyParams(exitRequest);

        exitRequest.setParkId(parkId);
        /**
         * 开始处理业务
         */
        try {
            String key2 = RedisConstants.QUERY_FEE_FAIL_PROFILE + dataCenterBaseRequest.getParkCode() + "_" + exitRequest.getChannelId();
            if (redisUtils.exists(key2)){
                redisUtils.remove(key2);
            }
            String key3 = RedisConstants.SWITCH_FAIL_PROFILE + dataCenterBaseRequest.getParkCode() + "_" + exitRequest.getChannelId();
            if (redisUtils.exists(key3)){
                redisUtils.remove(key3);
            }
            ObjectResponse objectResponse = orderSimpleExitService.exit(exitRequest, dataCenterBaseRequest.getParkCode());
            if (objectResponse == null) {
                return ObjectResponse.failed(CodeConstants.ERROR);
            } else {
                return objectResponse;
            }
        } catch (Exception e) {
            log.warn(String.valueOf(e.getMessage()), e);
            return ObjectResponse.failed(CodeConstants.ERROR);
        }

    }

}
