package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.park.ParkLicenseService;
import com.icetech.cloudcenter.domain.response.ParkLicenseDto;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ParkLicenseRequest;
import com.icetech.cloudcenter.domain.response.pnc.LicenseResponse;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SelectLicenceInfoServiceImpl extends AbstractService implements ReportService {
    private int LICENSE_STATUS_OK = 1;
    private int LICENSE_STATUS_NO = 2;
    private int LICENSE_STATUS_USE = 3;
    private int LICENSE_STATUS_INVALID = 4;
    private int LICENSE_STATUS_OVER = 5;
    @Autowired
    private ParkLicenseService parkLicenseService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ParkLicenseRequest parkLicenseRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), ParkLicenseRequest.class);
        verifyParams(parkLicenseRequest);
        LicenseResponse licenseResponse = new LicenseResponse();
        String license = getLicense(parkLicenseRequest.getLicenceInfo());
        if (StringUtils.isEmpty(license)) {
            licenseResponse.setLicenceStatus(2);
        }
        ObjectResponse<ParkLicenseDto> parkLicenseResponse = parkLicenseService.selectParkLicense(license);
        if (ObjectResponse.isSuccess(parkLicenseResponse)) {
            ParkLicenseDto data = parkLicenseResponse.getData();
            if (data.getGrantStatus() == 1) {//未发放
                licenseResponse.setLicenceStatus(LICENSE_STATUS_NO);
            } else if (data.getEnableStatus() == 2) {//已被使用
                licenseResponse.setLicenceStatus(LICENSE_STATUS_USE);
            } else if (data.getEnableStatus() == 3) {//作废
                licenseResponse.setLicenceStatus(LICENSE_STATUS_INVALID);
            } else if (data.getEnableStatus() == 4) {//已过期
                licenseResponse.setLicenceStatus(LICENSE_STATUS_OVER);
            } else {
                licenseResponse.setLicenceStatus(LICENSE_STATUS_OK);
            }
            return ObjectResponse.success(licenseResponse);
        }
        licenseResponse.setLicenceStatus(2);
        return ObjectResponse.success(licenseResponse);
    }

    /**
     * @param plusSaltLicense
     * @return
     */
    private String getLicense(String plusSaltLicense) {
        String license = "";
        char[] chars = plusSaltLicense.toCharArray();
        StringBuffer sf = new StringBuffer();
        for (int i = 1; i < chars.length + 1; i++) {
            if (i % 4 != 0) {
                sf.append(chars[i - 1]);
            }
        }
        license = sf.toString();

        return license;
    }

}
