package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.discount.DiscountService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.order.domain.entity.OrderDiscount;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.DiscountInfoRequest;
import com.icetech.cloudcenter.domain.response.pnc.DiscountInfoResponse;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class SearchDiscountInfoServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private DiscountService discountService;
    @Autowired
    private PublicHandle publicHandle;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        DiscountInfoRequest discountInfoRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), DiscountInfoRequest.class);

        //参数校验
        verifyParams(discountInfoRequest);

        /**
         * 开始处理业务
         */
        List<OrderDiscount> orderDiscounts = getOrderPays(parkId, discountInfoRequest);
        List<DiscountInfoResponse> discountInfoResponses = new ArrayList<DiscountInfoResponse>();
        for (int i=0;i<orderDiscounts.size();i++){
            OrderDiscount orderDiscount = orderDiscounts.get(i);
            DiscountInfoResponse discountInfoResponse = new DiscountInfoResponse();
            discountInfoResponse.setDiscountNo(orderDiscount.getDiscountNo());
            discountInfoResponse.setDiscountType(orderDiscount.getType());
            discountInfoResponse.setDiscountNumber(orderDiscount.getAmount());
            discountInfoResponse.setDiscountTime(orderDiscount.getSendTime().getTime() / 1000);
            discountInfoResponses.add(discountInfoResponse);
        }
        if (discountInfoResponses.size() <= 0){
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }else{
            return ObjectResponse.success(discountInfoResponses);
        }
    }

    private List<OrderDiscount> getOrderPays(Long parkId, DiscountInfoRequest discountInfoRequest) {
        String orderId = discountInfoRequest.getOrderId();
        String orderNum = publicHandle.convert2OrderNum(parkId, orderId);

        PageQuery<OrderDiscount> payPageQuery = new PageQuery<OrderDiscount>();
        OrderDiscount orderDiscount = new OrderDiscount();
        orderDiscount.setParkId(parkId);
        orderDiscount.setOrderNum(orderNum);
        payPageQuery.setParam(orderDiscount);
        ObjectResponse<List<OrderDiscount>> objectResponse = discountService.findList(payPageQuery);
        ObjectResponse.notError(objectResponse);
        return objectResponse.getData();
    }

}
