package com.icetech.park.service.report.pnc.impl;

import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.request.p2r.ShowPayInfoRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.RobotpayResultRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2r.impl.ShowPayInfoServiceImpl;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.report.pnc.ReportService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 机器人支付成功后展示二维码 <br>
 *     接口功能：当车主缴费成功后，需要展示相关二维码时使用此接口；
 */
@Service
@Slf4j
public class RobotpayResultServiceImpl extends AbstractService implements ReportService {

    /** 通道缓存管理 */
    @Autowired
    private CacheHandle cacheHandle;

    @Autowired
    private ShowPayInfoServiceImpl showPayInfoService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        // 从请求参数中获取约定的bizContent参数
        RobotpayResultRequest robotSayShowRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), RobotpayResultRequest.class);

        // 必填项参数校验
        verifyParams(robotSayShowRequest);

        // 获取管道机器人序列号
        String serialNumber = cacheHandle.getChannelRobot(dataCenterBaseRequest.getParkCode(), robotSayShowRequest.getChannelId());
        if (serialNumber != null) {
            // 封装下发机器人展示二维码所需要的参数
            ShowPayInfoRequest showPayInfoRequest = new ShowPayInfoRequest();
            showPayInfoRequest.setQrCodeUrl(robotSayShowRequest.getQrCodeUrl()); // 二维码URL，可以是开发票的URL
            showPayInfoRequest.setNoticeMsg(robotSayShowRequest.getNoticeMsg()); // 二维码上方提示信息
            ObjectResponse objectResponse = showPayInfoService.executeDown(parkId, serialNumber, showPayInfoRequest);
            return objectResponse;
        }

        log.info("[端网云]下发机器人展示二维码失败，未获取到通道机器人序列号，parkCode[{}]，channelId[{}]",
                dataCenterBaseRequest.getParkCode(), robotSayShowRequest.getChannelId());
        return ObjectResponse.failed(CodeConstants.ERROR_3003, "机器人设备不在线");
    }


}
