package com.icetech.park.service.report.pnc.impl;

import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.request.p2r.ShowPayInfoRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.RobotShowPayInfoRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2r.impl.ShowPayInfoServiceImpl;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.report.pnc.ReportService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 机器人支付信息展示实现 <br>
 *     接口功能：当车辆出场需要缴费时，第三方平台上传支付信息，机器人根据上产内容进行展示；
 */
@Service
@Slf4j
public class RobotShowPayInfoServiceImpl extends AbstractService implements ReportService {

    /** 机器人支付展示信息下发实现类 */
    @Autowired
    private ShowPayInfoServiceImpl showPayInfoService;

    /** 通道缓存管理 */
    @Autowired
    private CacheHandle cacheHandle;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        // 从请求参数中获取约定的bizContent参数
        RobotShowPayInfoRequest robotSayShowRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), RobotShowPayInfoRequest.class);

        // 必填项参数校验
        verifyParams(robotSayShowRequest);

        // 获取管道机器人序列号
        String serialNumber = cacheHandle.getChannelRobot(dataCenterBaseRequest.getParkCode(), robotSayShowRequest.getChannelId());
        if (serialNumber != null) {
            // 支付信息展示参数封装
            ShowPayInfoRequest showPayInfoRequest = new ShowPayInfoRequest();
            showPayInfoRequest.setOrderNum(robotSayShowRequest.getOrderId()); // 订单号
            showPayInfoRequest.setQrCodeUrl(robotSayShowRequest.getQrCodeUrl()); // 二维码URL
            showPayInfoRequest.setNoticeMsg(robotSayShowRequest.getNoticeMsg()); // 二维码上方提示信息
            showPayInfoRequest.setShow(robotSayShowRequest.getShow()); // 其他显示内容
            // 下发机器人展示支付信息
            ObjectResponse objectResponse = showPayInfoService.executeDown(parkId, serialNumber, showPayInfoRequest);
            if (objectResponse == null){
                return ObjectResponse.failed(CodeConstants.ERROR, "下发机器人失败");
            }else{
                return objectResponse;
            }
        }

        log.error("[云云]下发机器人支付展示信息失败，未获取到通道机器人序列号，parkCode：[{}]，channelId：[{}]",
                dataCenterBaseRequest.getParkCode(), robotSayShowRequest.getChannelId());
        return ObjectResponse.failed(CodeConstants.ERROR);
    }
}
