package com.icetech.park.service.report.pnc.impl;

import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.request.p2r.RobotHintRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.RobotSayShowRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.down.p2r.impl.HintServiceImpl;
import com.icetech.park.handle.CacheHandle;
import com.icetech.park.service.report.pnc.ReportService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 机器人语音屏显实现 <br>
 *     接口功能：车辆进出场时第三方平台控制机器人进行相应内容的屏显和语音播报；
 */
@Service
@Slf4j
public class RobotSayShowServiceImpl extends AbstractService implements ReportService {

    /** 下发机器人语音屏显实现类 */
    @Autowired
    private HintServiceImpl robotHintService;

    /** 通道缓存管理 */
    @Autowired
    private CacheHandle cacheHandle;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        // 从请求参数中获取约定的bizContent参数
        RobotSayShowRequest robotSayShowRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), RobotSayShowRequest.class);

        // 必填项参数校验
        verifyParams(robotSayShowRequest);

        // 获取通道机器人序列号
        String serialNumber = cacheHandle.getChannelRobot(dataCenterBaseRequest.getParkCode(), robotSayShowRequest.getChannelId());
        if (serialNumber != null) {
            // 封装下发机器人语音屏显需要的参数
            RobotHintRequest robotHintRequest = new RobotHintRequest();
            robotHintRequest.setPlateNum(robotSayShowRequest.getPlateNum()); // 车牌号
            robotHintRequest.setShow(robotSayShowRequest.getShow()); // 语音消息
            robotHintRequest.setSay(robotSayShowRequest.getSay()); // 屏显信息
            // 下发机器人进行语音屏显
            ObjectResponse objectResponse = robotHintService.executeDown(parkId, serialNumber, robotHintRequest);
            return objectResponse;
        }

        log.info("[端网云]下发机器人语音屏显失败，未获取到通道机器人序列号，parkCode[{}]，channelId[{}]",
                dataCenterBaseRequest.getParkCode(), robotSayShowRequest.getChannelId());
        return ObjectResponse.failed(CodeConstants.ERROR_3003, "机器人设备不在线");
    }
}
