package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.AlarmService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.RetentionCarRequest;
import com.icetech.cloudcenter.domain.vo.AisleInfoVo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Objects;

@Service("pncRetentionCarServiceImpl")
@Slf4j
public class RetentionCarServiceImpl extends AbstractService implements ReportService {

    @Resource
    private AlarmService alarmService;
    @Autowired
    private ParkService parkService;

    @Autowired
    private OrderInfoDao orderInfoDao;
    @Override
    public ObjectResponse<Void> report(DataCenterBaseRequest baseRequest, Long parkId) {
        RetentionCarRequest retentionCarLeaveRequest = JsonUtils.convert2bean(baseRequest.getBizContent(), RetentionCarRequest.class);
        //参数校验
        verifyParams(retentionCarLeaveRequest);
        ObjectResponse<Park> parkResponse = parkService.findByParkId(parkId);
        Park park = parkResponse.getData();
        if(Objects.isNull(park)){
            return ObjectResponse.success();
        }
        ParkInoutdevice parkInoutdevice = parkService.getChannelByCodeAndParkId(parkId, retentionCarLeaveRequest.getChannelId());
        if(Objects.isNull(parkInoutdevice)){
            return ObjectResponse.success();
        }
        //转换为平台订单号
        OrderInfo orderInfoSearch = new OrderInfo();
        orderInfoSearch.setLocalOrderNum(retentionCarLeaveRequest.getOrderId());
        orderInfoSearch.setParkId(parkId);
        OrderInfo orderInfoResult = orderInfoDao.selectLimitOneOrderByEnterDesc(orderInfoSearch);
        AisleInfoVo aisleInfoVo = new AisleInfoVo();
        aisleInfoVo.setParkCode(park.getParkCode());
        aisleInfoVo.setParkId(park.getId());
        //通道信息
        aisleInfoVo.setAisleType(parkInoutdevice.getInandoutType());
        aisleInfoVo.setAisleCode(parkInoutdevice.getInandoutCode());
        aisleInfoVo.setOrderNum(orderInfoResult == null?null:orderInfoResult.getOrderNum());
        aisleInfoVo.setImage(retentionCarLeaveRequest.getMaxImage());
        alarmService.aisleDurationAlarm(aisleInfoVo);
        return ObjectResponse.success();
    }
}
