package com.icetech.park.service.report.pnc.impl;

import com.icetech.basics.service.other.NotWorkDayService;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.QueryNotWorkDayRequest;
import com.icetech.cloudcenter.domain.response.pnc.QueryNotWorkDayResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryNotWorkDayServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private NotWorkDayService notWorkDayService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        QueryNotWorkDayRequest notWorkDayRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), QueryNotWorkDayRequest.class);

        return ObjectResponse.success(notWorkDayService.queryNotDays(notWorkDayRequest.getYear()));
    }

}
