package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.OrderCarInfoConstant;
import com.icetech.order.dao.OrderCarInfoDao;
import com.icetech.order.domain.entity.OrderCarInfo;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.QueryInParkOrderRequest;
import com.icetech.cloudcenter.domain.response.pnc.QueryInParkOrderResponse;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
@Slf4j
public class QueryInParkOrderServiceImpl extends AbstractService implements ReportService {

    @Resource
    private OrderService orderService;

    @Resource
    private OrderCarInfoDao orderCarInfoDao;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        QueryInParkOrderRequest inParkOrderRequest =
                JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), QueryInParkOrderRequest.class);
        //参数校验
        verifyParams(inParkOrderRequest);
        ObjectResponse<OrderInfo> objectResponse = orderService.findInPark(inParkOrderRequest.getPlateNum(),
                dataCenterBaseRequest.getParkCode());
        if (!ObjectResponse.isSuccess(objectResponse)) {
            return ObjectResponse.failed(objectResponse.getCode(), "未找到在场记录");
        }
        OrderInfo orderInfo = objectResponse.getData();

        OrderCarInfo orderCarInfo = orderCarInfoDao.selectByOrderNum(orderInfo.getOrderNum());
        if (orderCarInfo == null) {
            return ObjectResponse.failed(objectResponse.getCode(), "未找到订单信息");
        }
        if (OrderCarInfoConstant.IN_OUT_WAY_OFF_LINE != NumberUtils.toPrimitive(orderCarInfo.getEnterWay())) {
            return ObjectResponse.failed(CodeConstants.ERROR_404, "未找到订单信息");
        }
        QueryInParkOrderResponse queryInParkOrderResponse = QueryInParkOrderResponse.builder()
                .orderNum(orderInfo.getLocalOrderNum() == null
                        ? orderInfo.getOrderNum() : orderInfo.getLocalOrderNum())
                .plateNum(orderInfo.getPlateNum())
                .enterTime(orderInfo.getEnterTime())
                .type(orderInfo.getType())
                .carType(orderInfo.getCarType())
                .carDesc(orderInfo.getCarDesc())
                .enterImage(orderCarInfo.getEnterImage())
                .channelCode(orderCarInfo.getEnterChannelId())
                .build();
        return ObjectResponse.success(queryInParkOrderResponse);
    }
}
