package com.icetech.park.service.report.pnc.impl;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.request.PrepayReportRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.impl.ExternalServiceImpl;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PrepayReportServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private ExternalServiceImpl externalService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        PrepayReportRequest prepayReportRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), PrepayReportRequest.class);
        //参数校验
        verifyParams(prepayReportRequest);

        prepayReportRequest.setParkId(parkId);
        return externalService.prepayReport(prepayReportRequest);

    }

}
