package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.paycode.PayCodePrePayService;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.PncPayCodeRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PncPrePayCodeServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private PayCodePrePayService payCodePrePayService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {

        PncPayCodeRequest payCodeRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), PncPayCodeRequest.class);

        //参数校验
        verifyParams(payCodeRequest);
        return payCodePrePayService.pncPrePay(payCodeRequest.getParkCode(),payCodeRequest.getChannelId(),payCodeRequest.getOrderId(),payCodeRequest.getPayCode(),payCodeRequest.getPrice().toString());
    }

}
