package com.icetech.park.service.report.pnc.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ParkStatusRequest;
import com.icetech.cloudcenter.domain.request.pnc.RegionParkInfoRequest;
import com.icetech.cloudcenter.domain.response.pnc.ParkStatusResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.park.dao.park.ParkFreespaceDao;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.factory.UpdateFreeSpaceServiceFactory;
import com.icetech.park.service.freespace.UpdateFreeSpaceService;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.utils.RedisUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Service
public class ParkStatusServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private ParkService parkService;
    @Autowired
    private RedisUtils redisUtils;
    //在线通道缓存的超时时间，1分钟
    private static Long TIMEOUT_SECONDS = 70L;

    @Autowired
    private ParkRegionDao parkRegionDao;
    @Resource
    private ParkFreespaceDao parkFreespaceDao;
    @Resource
    private UpdateFreeSpaceServiceFactory updateFreeSpaceServiceFactory;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ParkStatusRequest parkStatusRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), ParkStatusRequest.class);
        //参数校验
        verifyParams(parkStatusRequest);
        //开始处理业务
        Long cloudTime = DateTools.unixTimestamp();
        if (parkStatusRequest.getChannelId() != null) {
            ObjectResponse<ParkInoutdevice> inOutDeviceByCode = parkService.getInOutDeviceByCode(parkId, parkStatusRequest.getChannelId());
            if (ObjectResponse.isSuccess(inOutDeviceByCode)) {
                redisUtils.set(RedisConstants.PNC_ONLINE_CHANNEL_PROFILE + dataCenterBaseRequest.getParkCode(), parkStatusRequest.getChannelId(), TIMEOUT_SECONDS);
            }
        }
        String hkey = String.valueOf(parkId);
        redisUtils.hPut(RedisConstants.PNC_HEARTBEAT_TIME, hkey, cloudTime);
        redisUtils.hPut(RedisConstants.PNC_VERSION, hkey, dataCenterBaseRequest.getVersionNum());
        redisUtils.hPut(RedisConstants.PNC_PROTOCOL, hkey, NumberUtils.toPrimitive(parkStatusRequest.getProtocol(), 1));
        Integer emptyNumber = parkStatusRequest.getEmptyNumber();

        // 场中场区域空车位处理
        if (CollectionUtils.isNotEmpty(parkStatusRequest.getRegionParkInfo())) {
            List<String> regionCodes = parkStatusRequest.getRegionParkInfo().stream().map(RegionParkInfoRequest::getRegionCode).filter(Objects::nonNull).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(regionCodes)) {
                Map<String, Integer> paramMap = parkStatusRequest.getRegionParkInfo().stream().filter(Objects::nonNull).collect(Collectors.toMap(RegionParkInfoRequest::getRegionCode, RegionParkInfoRequest::getRegionEmptyNumber));
                List<ParkRegion> parkRegions = parkRegionDao.selectList(Wrappers.lambdaQuery(ParkRegion.class).eq(ParkRegion::getParkId, parkId).eq(ParkRegion::getStatus, 0).in(ParkRegion::getRegionCode, regionCodes));
                if (CollectionUtils.isNotEmpty(parkRegions)) {
                    for (ParkRegion parkRegion : parkRegions) {
                        Integer freePark = paramMap.get(parkRegion.getRegionCode());
                        if (freePark != null && !freePark.equals(parkRegion.getFreePark())) {
                            ParkRegion parkRegionUpdate = new ParkRegion();
                            parkRegionUpdate.setId(parkRegion.getId());
                            parkRegionUpdate.setFreePark(freePark);
                            parkRegionUpdate.setRealFreePark(freePark);
                            parkRegionDao.updateById(parkRegionUpdate);
                        }
                    }
                }
                parkFreespaceDao.updateFreeSpaceByPark(parkId, emptyNumber);
            }
        } else {
            if (emptyNumber != null) {
                List<ParkRegion> parkRegions = parkRegionDao.selectByParkid(parkId);
                Long regionId = null;
                if (CollectionUtils.isNotEmpty(parkRegions)) {
                    //子区域
                    Optional<ParkRegion> first = parkRegions.stream().filter(parkRegion -> !Long.valueOf(0).equals(parkRegion.getFatherRelationId())).findFirst();
                    if (first.isPresent()) {
                        ParkFreespace parkFreespace = new ParkFreespace();
                        parkFreespace.setParkId(parkId);
                        parkFreespace = parkFreespaceDao.selectLimitOne(parkFreespace);
                        if (parkFreespace != null) {
                            emptyNumber = NumberUtils.toPrimitive(parkFreespace.getTotalNum()) - NumberUtils.toPrimitive(first.get().getFreePark());
                        }
                    } else {
                        regionId = parkRegions.get(0).getId();
                    }
                }
                UpdateFreeSpaceService updateFreeSpaceService = updateFreeSpaceServiceFactory.getUpdateFreeSpaceService(parkId);
                updateFreeSpaceService.updateFreeSpace(parkId, regionId, emptyNumber);
            }
        }
        // 返回结果
        ParkStatusResponse parkStatusResponse = new ParkStatusResponse();
        //查询车场信息
        Park park = getParkByParkId(parkId).orElse((Park) new Park().setChargeCarSpace(0));
        parkStatusResponse.setChargeCarSpace(park.getChargeCarSpace() == null ? 0 : park.getChargeCarSpace());
        parkStatusResponse.setTotalPark(park.getTotalPark());
        parkStatusResponse.setTime(cloudTime);
        return ObjectResponse.success(parkStatusResponse);
    }

    /**
     * 获取车场信息
     *
     * @param parkId 车场id
     * @return park
     */
    private Optional<Park> getParkByParkId(Long parkId) {
        ObjectResponse<Park> parkObjectResponse = parkService.findByParkId(parkId);
        if (ObjectResponse.isSuccess(parkObjectResponse)) {
            Park park = parkObjectResponse.getData();
            if (Objects.nonNull(park)) {
                return Optional.of(park);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}
