package com.icetech.park.service.report.pnc.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.dao.area.AreaProvinceDao;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.basics.domain.entity.AreaProvince;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.basics.domain.entity.park.ParkConfig;
import com.icetech.park.domain.entity.park.ParkFreespace;
import com.icetech.park.domain.entity.park.ParkGuide;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ParkConfigUpRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.park.impl.ParkConfigServiceImpl;
import com.icetech.park.service.park.impl.ParkFreeSpaceServiceImpl;
import com.icetech.park.service.park.impl.ParkGuideServiceImpl;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.third.service.third.SendInfoServiceImpl;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.NumberUtils;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 车场配置上报
 */
@Slf4j
@Service
public class ParkConfigUpServiceImpl extends AbstractService implements ReportService {
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private ParkConfigServiceImpl parkConfigService;
    @Autowired
    private ParkFreeSpaceServiceImpl parkFreeSpaceService;
    @Autowired
    private AreaProvinceDao areaProvinceDao;
    @Autowired
    private ParkGuideServiceImpl parkGuideService;
    @Autowired
    private SendInfoServiceImpl sendInfoService;
    @Autowired
    private ParkRegionDao parkRegionDao;

    @Override
    @Transactional
    public ObjectResponse report(DataCenterBaseRequest baseRequest, Long parkId) throws Exception {
        if (baseRequest.getBizContent() == null) return ObjectResponse.failed(CodeConstantsEnum.ERROR_400);
        ParkConfigUpRequest request = JsonUtils.convert2bean(baseRequest.getBizContent(), ParkConfigUpRequest.class);
        if (request == null || StringUtils.isBlank(request.getParkName())) return ObjectResponse.failed(CodeConstantsEnum.ERROR_400);
        ObjectResponse<Park> parkResp = parkService.findByParkId(parkId);
        ObjectResponse.notError(parkResp);
        ObjectResponse<ParkConfig> parkConfigResp = parkService.getParkConfig(parkId);
        ObjectResponse.notError(parkConfigResp);
        ObjectResponse<ParkFreespace> spaceResp = parkFreeSpaceService.getSpaceByPark(parkId);
        ObjectResponse.notError(spaceResp);
        Park park = parkResp.getData();
        ParkConfig parkConfig = parkConfigResp.getData();
        ParkFreespace space = spaceResp.getData();
        AreaProvince province = areaProvinceDao.selectLimitOne(Wrappers.lambdaQuery(AreaProvince.class).eq(AreaProvince::getAbbr, request.getProvinceName()));
        if (province == null) {
            throw new ResponseBodyException(CodeConstants.ERROR_400, "找不到对应省份信息");
        }
        ParkRegion parkRegion = parkRegionDao.selectOutByParkid(parkId);
        if (parkRegion == null) {
            throw new ResponseBodyException(CodeConstants.ERROR_400, "找不到对应区域信息");
        }

        Park newPark = buildPark(request);
        newPark.setId(parkId);
        newPark.setProvinceId(province.getId());
        ParkConfig newParkConfig = buildParkConfig(request);
        newParkConfig.setId(parkConfig.getId());
        ParkFreespace newSpace = buildParkFreespace(request);
        newSpace.setId(space.getId());
        ParkRegion newRegion = buildRegion(request);
        newRegion.setId(parkRegion.getId());

        parkService.updateById(newPark);
        parkConfigService.updateById(newParkConfig);
        parkFreeSpaceService.updateById(newSpace);
        parkRegionDao.updateById(newRegion);
        ParkGuide guide = new ParkGuide();
        guide.setParkId(parkId);
        guide.setStep(1);
        parkGuideService.updateByParkId(guide);
        sendInfoService.save(SendInfo.buildUnneeded(parkId, newParkConfig.getId(), DownServiceEnum.车场配置.getServiceType(), "本地上报"));
        parkService.removeParkParamFromRedis(park.getParkCode(), park.getId());
        return ObjectResponse.success();
    }

    private Park buildPark(ParkConfigUpRequest request) {
        Park park = new Park();
//        park.setId(request.getId());
//        park.setParkCode(request.getParkCode());
        park.setParkName(request.getParkName());
//        park.setInstitutionId(request.getInstitutionId());
//        park.setProvinceId(request.getProvinceId());
//        park.setCityAreaId(request.getCityAreaId());
//        park.setDistrictId(request.getDistrictId());
//        park.setPhone(request.getPhone());
//        park.setAddress(request.getAddress());
//        park.setTotalExit(request.getTotalExit());
//        park.setTotalEnter(request.getTotalEnter());
        park.setTotalPark(request.getTotalPark());
//        park.setTotalFixedspaces(request.getTotalFixedspaces());
//        park.setParkType(request.getParkType());
//        park.setParkClientType(request.getParkClientType());
        park.setSwitchFeeTime(request.getSwitchFreeTime());
//        park.setStatus(request.getStatus());
//        park.setAssetType(request.getAssetType());
//        park.setCooperateType(request.getCooperateType());
//        park.setParkProperty(request.getParkProperty());
        int isInterior = NumberUtils.toPrimitive(request.getIsMidfield(), 0) == 1 ? 1 : 0;
        park.setIsInterior(isInterior);
        // 本地系统上报为场中场时，车场嵌套类型默认为平行区域；上报为非场中场时，车场嵌套类型默认为不嵌套
        park.setNestType(isInterior == 1 ? 3 : 0);
//        park.setLat(request.getLat());
//        park.setLng(request.getLng());
//        park.setKey(request.getKey());
//        park.setCreateTime(request.getCreateTime());
//        park.setAdder(request.getAdder());
//        park.setUpdateTime(request.getUpdateTime());
//        park.setUpdateUser(request.getUpdateUser());
//        park.setParkBusinessLicense(request.getParkBusinessLicense());
//        park.setParkImgs(request.getParkImgs());
//        park.setTelphone(request.getTelphone());
//        park.setProvinceName(request.getProvinceName());
        return park;
    }

    private ParkConfig buildParkConfig(ParkConfigUpRequest request) {
        ParkConfig config = new ParkConfig();
//        config.setId(request.getId());
//        config.setParkId(request.getParkId());
//        config.setIsSync(request.getIsSync());
        config.setBillPrecision(request.getBilPrecision());
        config.setIsfreeSpecialcar(request.getIsFreeSpecialCar());
        config.setIssupAbmanage(request.getIsMultipleVehicles());
        config.setSwitchTm(request.getMultipleTime());
        config.setSwitchType(request.getMultipleBillType());
        config.setIsreleaseFreetm(request.getIsReleaseFreetm());
//        config.setIsupimage(request.getIsupimage());
        config.setIsEpayment(request.getIsEpayMent());
//        config.setEPayment(request.getEPayment());
        config.setIsNosenpayment(request.getIsNosenPayMent());
//        config.setNoSenPayment(request.getNoSenPayment());
//        config.setUpdateTime(request.getUpdateTime());
//        config.setUpdateUser(request.getUpdateUser());
        config.setIsfreeAfterpay(request.getFreeTimeAfterPay());
//        config.setDataCollection(request.getDataCollection());
//        config.setCloudCharge(request.getCloudCharge());
//        config.setIsInvoice(request.getIsInvoice());
        config.setFreetimeStatus(request.getFreeTimeStatus());
        config.setIsFilltime(request.getIsFillTime());
        config.setOvertimeBillType(request.getOverTimeBillType());
        config.setIsallowfreetmonce(request.getIsAllowFreeTmonce());
        config.setIsnotgetsmallchange(request.getIsRounding());
        config.setIsfixedfees(request.getIsFixedFee());
        config.setFixedfeevalue(request.getFixedFeeValue());
        config.setFixedFeeValueBig(request.getFixedFeeValueBig());
        // 对应关系为上报的值 -1
        config.setChargeVersionNum(request.getBillVersion() == null ? 0 : request.getBillVersion() - 1);
//        config.setIsNoplateRepeatenter(request.getIsNoplateRepeatenter());
        /*config.setIsFullForbidenter(request.getIsFullForbidEnter());
        config.setIsFullForbidMonthEnter(request.getIsFullForbidMonthEnter());
        config.setIsFullForbidVIPEnter(request.getIsFullForbidVIPEnter());
        config.setIsFullForbidReservEnter(request.getIsFullForbidReservEnter());
        config.setIsFullForbidStoreEnter(request.getIsFullForbidStoreEnter());
        config.setFullEmptynum(request.getFullEmptyNum());*/
        config.setMoneyunitType(request.getMonetaryUnit());
        config.setIsCardcount(request.getIsCarDcount());
//        config.setCarenexTimelong(request.getCarenexTimelong());
//        config.setRetentionAlarmMethod(request.getRetentionAlarmMethod());
//        config.setRetentionIntervalTime(request.getRetentionIntervalTime());
//        config.setRetentionCancelTime(request.getRetentionCancelTime());
        config.setIsSpecialPark(request.getIsInOutPass() == 1 ? 1 : 0);
        config.setEnexMinTime(request.getEnexMinTime());
        config.setExenMinTime(request.getExenMinTime());
        config.setDisplayTerminal(request.getScreenType());
        config.setLedcardType(request.getCtrlCardModel());
        config.setTtsType(request.getIsSupportTTS() == 1 ? 1 : 0);
        config.setDualcameraTime(request.getDualCameraTime());
//        config.setDualcameraEnextime(request.getDualcameraEnextime());
//        config.setRedpackModel(request.getRedpackModel());
//        config.setIsVisit(request.getIsVisit());
        config.setVisitIscharge(request.getVisitIscharge());
//        config.setIsNewenergyCharge(request.getIsNewenergyCharge());
//        config.setEntryPayFlag(request.getEntryPayFlag());
        config.setIsNocardCheck(request.getIsNocardCheck());
        config.setIsExpireMc(NumberUtils.toPrimitive(request.getOverTimeMonthlyCard()));
        config.setExpireMcDays(request.getExpireMcDays());
        config.setIsAllowOvertimeCar(NumberUtils.toPrimitive(request.getIsOverTimeMonth()));
        config.setOverTimeDay(request.getOverTimeDay());
        //config.setIsFullForbidblackenter(request.getIsFullForbidBlackEnter());
//        config.setVipCarTypeId(request.getVipCarTypeId());    // 无法转换ID信息，转移至VIP车辆类型上报时处理
        config.setFreeCarReenter(request.getFreeCarReenter());
//        config.setVisitInoutNum(request.getVisitInoutNum());
        config.setCalcSpaceMethod(request.getCalcSpaceMethod());
//        config.setDelOrderCalcSpaceFlag(request.getDelOrderCalcSpaceFlag(0));
//        config.setIsAuto(request.getIsAuto());
//        config.setAutoRenewMonthCardFlag(request.getAutoRenewMonthCardFlag());
        config.setPlateFilterType(request.getPlateFilterType());
        config.setFilterTime(request.getFilterTime());
//        config.setParkingInvoiceDays(request.getParkingInvoiceDays());
//        config.setMonthcardInvoiceDays(request.getMonthcardInvoiceDays());
        return config;
    }

    private ParkFreespace buildParkFreespace(ParkConfigUpRequest request) {
        ParkFreespace space = new ParkFreespace();
        space.setFreeSpace(request.getFreePark());
        space.setRealFreeSpace(request.getFreePark());
        space.setTotalNum(request.getTotalPark());
        return space;
    }

    private ParkRegion buildRegion(ParkConfigUpRequest request) {
        ParkRegion parkRegion = new ParkRegion();
        parkRegion.setIsFullForbidenter(request.getIsFullForbidEnter());
        parkRegion.setIsFullForbidMonthEnter(request.getIsFullForbidMonthEnter());
        parkRegion.setIsFullForbidVIPEnter(request.getIsFullForbidVIPEnter());
        parkRegion.setIsFullForbidReservEnter(request.getIsFullForbidReservEnter());
        parkRegion.setIsFullForbidStoreEnter(request.getIsFullForbidStoreEnter());
        parkRegion.setFullEmptynum(request.getFullEmptyNum());
        parkRegion.setIsFullForbidblackenter(request.getIsFullForbidBlackEnter());
        parkRegion.setVipCarTypeId(request.getVipCarTypeId());
        return parkRegion;
    }
}
