package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.order.OrderPayService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.PayStatusConstants;
import com.icetech.order.domain.entity.OrderPay;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.domain.response.PageQuery;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.PaidInfoRequest;
import com.icetech.cloudcenter.domain.response.pnc.PaidInfoResponse;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class PaidInfoServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private OrderPayService orderPayService;

    @Autowired
    private PublicHandle publicHandle;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        PaidInfoRequest paidInfoRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), PaidInfoRequest.class);

        //参数校验
        verifyParams(paidInfoRequest);

        /**
         * 开始处理业务
         */
        List<OrderPay> orderPays = getOrderPays(parkId, paidInfoRequest);
        List<PaidInfoResponse> paidInfoResponses = new ArrayList<>();
        for (int i=0;i<orderPays.size();i++){
            OrderPay orderPay1 = orderPays.get(i);
            PaidInfoResponse paidInfoResponse = new PaidInfoResponse();
            BeanUtils.copyProperties(orderPay1, paidInfoResponse);
            paidInfoResponses.add(paidInfoResponse);
        }
        if (paidInfoResponses.size() <= 0){
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }else{
            return ObjectResponse.success(paidInfoResponses);
        }
    }

    private List<OrderPay> getOrderPays(Long parkId, PaidInfoRequest paidInfoRequest) {
        //转换到orderNum
        String orderId = paidInfoRequest.getOrderId();
        String orderNum = publicHandle.convert2OrderNum(parkId, orderId);

        PageQuery<OrderPay> payPageQuery = new PageQuery<>();
        OrderPay orderPay = new OrderPay();
        orderPay.setParkId(parkId);
        orderPay.setOrderNum(orderNum);
        orderPay.setPayStatus(PayStatusConstants.PAID);
        payPageQuery.setParam(orderPay);
        ObjectResponse<List<OrderPay>> objectResponse = orderPayService.findList(payPageQuery);
        ObjectResponse.notError(objectResponse);
        return objectResponse.getData();
    }

}
