package com.icetech.park.service.report.pnc.impl;

import java.util.Date;

import com.alibaba.fastjson.JSON;
import com.icetech.basics.dao.park.ParkRegionDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.order.domain.entity.OrderSonInfo;
import com.icetech.order.domain.entity.OrderTrack;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.basics.domain.entity.park.ParkRegion;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.OrderTraceUploadRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.order.impl.OrderServiceImpl;
import com.icetech.order.service.impl.OrderSonInfoServiceImpl;
import com.icetech.order.service.impl.OrderTrackServiceImpl;
import com.icetech.basics.service.park.impl.ParkServiceImpl;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderTrackUploadServiceImpl extends AbstractService implements ReportService {
    @Autowired
    private ParkRegionDao parkRegionDao;
    @Autowired
    private ParkServiceImpl parkService;
    @Autowired
    private OrderServiceImpl orderService;
    @Autowired
    private OrderSonInfoServiceImpl orderSonInfoService;
    @Autowired
    private OrderTrackServiceImpl orderTrackService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        OrderTraceUploadRequest orderTraceUploadRequest = JSON.parseObject(JSON.toJSONString(dataCenterBaseRequest.getBizContent()), OrderTraceUploadRequest.class);
        ParkRegion region = parkRegionDao.getRegionByCode(parkId, orderTraceUploadRequest.getRegionCode());
        if (region == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_400, "区域不存在");
        }
        ParkInoutdevice channel = parkService.getChannelByCodeAndParkId(parkId, orderTraceUploadRequest.getChannelCode());
        if (channel == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_400, "通道不存在");
        }
        OrderInfo orderInfo = orderService.selectLimitOne(orderService.getLambdaQueryWrapper()
                .eq(OrderInfo::getParkId, parkId)
//                .eq(OrderInfo::getRegionId, region.getId())
                .eq(OrderInfo::getLocalOrderNum, orderTraceUploadRequest.getOrderId()));
        if (orderInfo == null) {
            return ObjectResponse.failed(CodeConstants.ERROR_400, "订单不存在");
        } else if (orderInfo.getHasSon() == 1) {
            orderInfo = orderSonInfoService.selectLimitOne(orderSonInfoService.getLambdaQueryWrapper()
                    .eq(OrderSonInfo::getParkId, parkId)
                    .eq(OrderSonInfo::getRegionId, region.getId())
                    .eq(OrderSonInfo::getLocalOrderNum, orderTraceUploadRequest.getOrderId()));
            if (orderInfo == null) {
                return ObjectResponse.failed(CodeConstants.ERROR_400, "订单不存在");
            }
        }

        OrderTrack orderTrack = new OrderTrack();
        orderTrack.setParkId(parkId);
        orderTrack.setRegionId(region.getId());
        orderTrack.setOrderNum(orderInfo.getOrderNum());
        orderTrack.setRecordType(orderTraceUploadRequest.getRecordType());
        orderTrack.setEnexTime(orderTraceUploadRequest.getEnexTime());
        OrderTrack existsOrderTrack = orderTrackService.selectLimitOne(orderTrack);
        if (existsOrderTrack != null) {
            return ObjectResponse.failed(CodeConstants.ERROR_405, "订单轨迹已存在");
        }

        orderTrack.setChannelName(channel.getInandoutName());
        orderTrack.setPlateNum(orderInfo.getPlateNum());
        orderTrack.setType(orderInfo.getType());
        orderTrack.setImage(orderTraceUploadRequest.getImage());
        orderTrack.setInoutEvent(orderTraceUploadRequest.getInoutEvent());
        orderTrack.setOperAccount(orderTraceUploadRequest.getOperAccount());
        orderTrack.setExTerminal(orderTraceUploadRequest.getExTerminal());
        orderTrack.setOpenReason(orderTraceUploadRequest.getExceptionReason());
        orderTrack.setCreateTime(new Date());

        orderTrackService.save(orderTrack);
        return ObjectResponse.success();
    }
}
