package com.icetech.park.service.report.pnc.impl;

import com.alibaba.fastjson.JSON;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.basics.config.GrayProperties;
import com.icetech.basics.dao.park.ParkInoutdeviceDao;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ModifyCtrlCardTypeRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.redis.handle.RedisHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author wanggang
 * @create 2023-02-21 17:45
 */
@Service
public class ModifyCtrlCardTypeServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private ParkService parkService;

    @Autowired
    private ParkInoutdeviceDao parkInoutdeviceDao;

    @Autowired
    private GrayProperties grayProperties;

    @Resource
    private RedisHandle redisHandle;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ModifyCtrlCardTypeRequest request = JSON.parseObject(JSON.toJSONString(dataCenterBaseRequest.getBizContent()), ModifyCtrlCardTypeRequest.class);
        //参数校验
        verifyParams(request);
        ObjectResponse<ParkInoutdevice> deviceObj = parkService.getInoutDeviceByCode(request.getChannelCode());
        if (!ObjectResponse.isSuccess(deviceObj)) {
            return ObjectResponse.failed(CodeConstants.ERROR_400, "通道不存在");
        }
        ParkInoutdevice inOutDevice = deviceObj.getData();
        // 更新数据并清空缓冲
        if (!inOutDevice.getLedcardType().equals(request.getCtrlCardType()) ||
                !inOutDevice.getTtsType().equals(request.getTtsType())) {
            ParkInoutdevice update = new ParkInoutdevice();
            update.setId(inOutDevice.getId());
            update.setLedcardType(request.getCtrlCardType());
            update.setTtsType(request.getTtsType());
            parkInoutdeviceDao.updateById(update);
            // 删除通道id和code缓冲
            String cacheKey = RedisKeyConstants.KEY_PREFIX_PARK_CHANNEL_CODE + inOutDevice.getInandoutCode();
            String cacheIdKey = RedisKeyConstants.KEY_PREFIX_PARK_CHANNEL + inOutDevice.getId();
            if (grayProperties.isCacheEnable()) {
                cacheKey = RedisKeyConstants.KEY_PREFIX_GRAY + cacheKey;
                cacheIdKey = RedisKeyConstants.KEY_PREFIX_GRAY + cacheIdKey;
            }
            redisHandle.delete(cacheKey);
            redisHandle.delete(cacheIdKey);
        }
        return ObjectResponse.success();
    }
}
