package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.order.OrderService;
import com.icetech.cloudcenter.domain.order.ModifyCarDto;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ModifyCarUpRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModifyCarUpServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private OrderService orderService;
    @Autowired
    private PublicHandle publicHandle;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ModifyCarUpRequest modifyCarUpRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), ModifyCarUpRequest.class);

        //参数校验
        verifyParams(modifyCarUpRequest);

        /*
         * 开始处理业务
         */
        String orderNum = publicHandle.convert2OrderNum(parkId, modifyCarUpRequest.getOrderId());
        ModifyCarDto modifyCarDto = new ModifyCarDto();
        BeanUtils.copyProperties(modifyCarUpRequest, modifyCarDto);
        modifyCarDto.setOrderNum(orderNum);
        modifyCarDto.setSyncLocal(false);
        return orderService.modifyCar(modifyCarDto);
    }


}
