package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.park.ParkLicenseService;
import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.response.ParkLicenseDto;
import com.icetech.park.domain.entity.park.Park;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ParkLicenseRequest;
import com.icetech.cloudcenter.domain.response.pnc.LicenseResponse;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogonLicenceInfoServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private ParkService parkService;
    @Autowired
    private ParkLicenseService parkLicenseService;
    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ParkLicenseRequest parkLicenseRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), ParkLicenseRequest.class);
        verifyParams(parkLicenseRequest);
        LicenseResponse licenseResponse = new LicenseResponse();
        String license = getLicense(parkLicenseRequest.getLicenceInfo());
        if(StringUtils.isEmpty(license)){
            licenseResponse.setLicenceStatus(2);
            return ObjectResponse.success(licenseResponse);
        }
        ObjectResponse<Park> byParkCode = parkService.findByParkCode(dataCenterBaseRequest.getParkCode());
        if(!ObjectResponse.isSuccess(byParkCode)){
            return ObjectResponse.failed(CodeConstants.ERROR_404,"未找到该车场["+byParkCode+"]");
        }
        ObjectResponse<ParkLicenseDto> parkLicenseDto = parkLicenseService.registerParkLicense(byParkCode.getData().getId(), license);
        ParkLicenseDto data = parkLicenseDto.getData();
        licenseResponse.setLicenceStatus(data.getLicenceStatus());
        if(ObjectResponse.isSuccess(parkLicenseDto)){
            licenseResponse.setLicenceType(data.getType());
            licenseResponse.setEnablingTime(data.getEnableTime().getTime());
            if(data.getType() == 2){
                licenseResponse.setUseDays(data.getUseDays());
            }
        }
        return ObjectResponse.success(licenseResponse);
    }

    /**
     *
     * @param plusSaltLicense
     * @return
     */
    private String getLicense(String plusSaltLicense){
        String license = "";
        if(plusSaltLicense.length() == 40){
            char[] chars = plusSaltLicense.toCharArray();
            StringBuffer sf = new StringBuffer();
            for (int i = 1; i < chars.length+1; i++) {
                if(i%4 == 0){
                    System.out.println(chars[i-1]);
                }else{
                    sf.append(chars[i-1]);
                }
            }
            license = sf.toString();
        }else if(plusSaltLicense.length() == 32){

        }
        return license;
    }

    public static void main(String[] args) {
//        String s = "WDA#21D#AD2#EWD#A21#DAD#2EW#DA2#1DA#D2E#";
        String s = "00bD5ead2c9R276207fr8b8Tbcaveae58cdp841X";
        System.out.println(s.length());
        char[] chars = s.toCharArray();
        StringBuffer sf = new StringBuffer();
        for (int i = 1; i < chars.length+1; i++) {
            if(i%4 == 0){
                System.out.println(chars[i-1]);
            }else{
                sf.append(chars[i-1]);
            }
        }
        System.out.println(sf.toString());
    }
}
