package com.icetech.park.service.report.pnc.impl;

import javax.annotation.Resource;

import com.icetech.cloudcenter.api.order.OrderExitService;
import com.icetech.cloudcenter.domain.request.ExitRequest;
import com.icetech.park.mongo.document.ExitRecord;
import com.icetech.park.service.record.ExitRecordService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.park.service.report.pnc.AbstractExitService;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.utils.RedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class ExitServiceImpl extends AbstractExitService implements ReportService {

    @Autowired
    private OrderExitService orderExitService;
    @Autowired
    private RedisUtils redisUtils;
    @Resource
    private ExitRecordService exitRecordService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ExitRequest exitRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), ExitRequest.class);

        // 参数校验
        if (verifyParams(exitRequest)){
            exitRequest.setParkId(parkId);
            // 记录上报信息
            addExitRecord(exitRequest);

            // 开始处理业务
            try {
                String key2 = RedisConstants.QUERY_FEE_FAIL_PROFILE + dataCenterBaseRequest.getParkCode() + "_" + exitRequest.getChannelId();
                if (redisUtils.exists(key2)){
                    redisUtils.remove(key2);
                }
                String key3 = RedisConstants.SWITCH_FAIL_PROFILE + dataCenterBaseRequest.getParkCode() + "_" + exitRequest.getChannelId();
                if (redisUtils.exists(key3)){
                    redisUtils.remove(key3);
                }
                ObjectResponse objectResponse = orderExitService.exit(exitRequest,dataCenterBaseRequest.getParkCode());
                if (objectResponse == null) {
                    return ObjectResponse.failed(CodeConstants.ERROR);
                } else {
                    return objectResponse;
                }
            } catch (ResponseBodyException e) {
                throw e;
            } catch (Exception e) {
                log.error("[端网云]离场上报处理失败", e);
                return ObjectResponse.failed(CodeConstants.ERROR);
            }
        }else {
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }

    }

    private void addExitRecord(ExitRequest request) {
        ExitRecord record = new ExitRecord();
        BeanUtils.copyProperties(request,record);
        record.setOrderNum(request.getOrderId());
        record.setImage(request.getExitImage());
        record.setSmallImage(request.getSmallImage());
        exitRecordService.saveRecordAsync(record);
    }
}
