package com.icetech.park.service.report.pnc.impl;

import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ExitPayCautionRequest;
import com.icetech.common.utils.StringUtils;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.showsay.CommonShowHandle;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.utils.RedisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class ExitPayCautionServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private CommonShowHandle commonShowHandle;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {

        ExitPayCautionRequest exitPayCautionRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), ExitPayCautionRequest.class);

        //参数校验
        verifyParams(exitPayCautionRequest);

        /*
         * 开始处理业务
         */
        exitPayCautionRequest.setParkCode(dataCenterBaseRequest.getParkCode());
        String key1 = RedisConstants.PNC_EXIT_PAY_CHANNEL_PROFILE + parkId + "_" + exitPayCautionRequest.getChannelId();
        String key2 = RedisConstants.PNC_EXIT_PAY_ORDER_PROFILE + parkId + "_" + exitPayCautionRequest.getOrderId();
        //30分钟有效期
        ExitPayCautionRequest old = redisUtils.get(key1, ExitPayCautionRequest.class);
        if (old != null){
            String orderId = old.getOrderId();
            String oldOrder = RedisConstants.PNC_EXIT_PAY_ORDER_PROFILE + parkId + "_" + orderId;
            redisUtils.remove(oldOrder);
            redisUtils.remove(key1);
        }
        redisUtils.set(key1, exitPayCautionRequest, 30 * 60L);
        redisUtils.set(key2, exitPayCautionRequest, 30 * 60L);
        Map<String, Object> param = new HashMap<>();
        param.put("fee", exitPayCautionRequest.getUnpayPrice());
        String thirdPayUrl = commonShowHandle.getThirdPayUrl(parkId, dataCenterBaseRequest.getParkCode(), exitPayCautionRequest.getChannelId(),
                null, exitPayCautionRequest.getPlateNum(), param);
        if (StringUtils.isNotBlank(thirdPayUrl)) {
            Map<String, Object> ret = new HashMap<>();
            ret.put("payQrCode", thirdPayUrl);
            return ObjectResponse.success(ret);
        }
        return ObjectResponse.success();
    }

}
