package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.park.domain.entity.park.ExitIdentify;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.service.third.MqPushService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class ExitIdentifyServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private MqPushService mqPushService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ExitIdentify request = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), ExitIdentify.class);
        //参数校验
        verifyParams(request);
        request.setParkId(parkId);
        request.setParkCode(dataCenterBaseRequest.getParkCode());
        if ("无牌车".equals(request.getPlateNum())) {
            request.setPlateNum("未识别");
        }
        log.info("[端网云]离场识别发送的请求参数[{}]", JsonUtils.toJsonString(request));
        // 消息转发
        mqPushService.pushExitIdentify(request);
        return ObjectResponse.success();
    }

}
