package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.cloudcenter.domain.request.OpeningDtoRequest;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.ExceptionOpenRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.utils.RedisUtils;
import com.icetech.common.utils.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class ExceptionOpenServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private ParkService parkService;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {

        ExceptionOpenRequest exceptionOpenRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), ExceptionOpenRequest.class);

        //参数校验
        verifyParams(exceptionOpenRequest);

        /*
         * 开始处理业务
         */
        OpeningDtoRequest openingDtoRequest = new OpeningDtoRequest();
        openingDtoRequest.setRecordType(exceptionOpenRequest.getEnexType());
        openingDtoRequest.setParkCode(dataCenterBaseRequest.getParkCode());
        openingDtoRequest.setPlateNum(exceptionOpenRequest.getPlateNum());
        openingDtoRequest.setExecuteTime(exceptionOpenRequest.getLiftTime());
        String openImage = exceptionOpenRequest.getOpenImage();
        String fileId = exceptionOpenRequest.getFileId();
        if (fileId != null){
            String imgFileName = redisUtils.get(RedisConstants.PNC_FILEID_PROFILE + dataCenterBaseRequest.getParkCode() + fileId, String.class);
            openingDtoRequest.setImgUrl(imgFileName);
        }else{
            openingDtoRequest.setImgUrl(openImage);
        }
        openingDtoRequest.setAisleCode(exceptionOpenRequest.getChannelId());
        openingDtoRequest.setReasonType(exceptionOpenRequest.getOpenReason());
        openingDtoRequest.setOperAccount(exceptionOpenRequest.getOperAccount());
        openingDtoRequest.setSourcegate(exceptionOpenRequest.getOpenType());
        if (StringUtils.isNotBlank(exceptionOpenRequest.getOrderId())) {
            try {
                String orderNum = publicHandle.convert2OrderNum(parkId, exceptionOpenRequest.getOrderId());
                openingDtoRequest.setOrderNum(orderNum);
            } catch (ResponseBodyException e) {
                log.warn("订单不存在, {}", exceptionOpenRequest);
            }
        }
        return parkService.saveOpeningRecord(openingDtoRequest);

    }

}
