package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.EtcPermissionRequest;
import com.icetech.cloudcenter.domain.response.pnc.EtcPermissionResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.common.utils.StringUtils;
import com.icetech.order.dao.OrderInfoDao;
import com.icetech.order.domain.entity.OrderInfo;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Objects;

import static com.icetech.cloudcenter.domain.constants.RedisConstants.*;

@Service
@Slf4j
public class EtcPermissionServiceImpl extends AbstractService implements ReportService {


    @Autowired
    private OrderInfoDao orderInfoDao;
    @Autowired
    private StringRedisTemplate redisTemplate;

    @Override
    public ObjectResponse<EtcPermissionResponse> report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {

        EtcPermissionRequest etcPermissionRequest = JsonUtils.convert2bean(
            dataCenterBaseRequest.getBizContent(), EtcPermissionRequest.class);
        //参数校验
        verifyParams(etcPermissionRequest);

        EtcPermissionResponse etcPermissionResponse = new EtcPermissionResponse();
        //查询订单信息
        OrderInfo query = new OrderInfo();
        query.setLocalOrderNum(etcPermissionRequest.getOrderId());
        OrderInfo orderInfo = orderInfoDao.selectLimitOneOrderByEnterDesc(query);
        if (Objects.isNull(orderInfo)) {
            orderInfo = orderInfoDao.selectByOrderNum(etcPermissionRequest.getOrderId());
            if (orderInfo == null) {
                etcPermissionResponse.setEtcPay(1);
                return ObjectResponse.success(etcPermissionResponse);
            }
        }

        //获取ETC支付权限
        String lock1 = redisTemplate.opsForValue().get(PAY_LOCK_KEY + dataCenterBaseRequest.getParkCode() + orderInfo.getOrderNum());
        String lock2 = redisTemplate.opsForValue().get(PAY_AFTER_LOCK_KEY + orderInfo.getOrderNum());
        log.info("[etc支付获取支付锁 orderNum {} lock {} {}]", orderInfo.getOrderNum(), lock1,lock2);
        if (StringUtils.isNotBlank(lock1) || StringUtils.isNotBlank(lock2)) {
            log.info("[etc支付权限有其他支付渠道在支付该订单 orderNum {} lock {} {}]", orderInfo.getOrderNum(), lock1,lock2);
            etcPermissionResponse.setEtcPay(0);
        }else{
            etcPermissionResponse.setEtcPay(1);
        }
        return ObjectResponse.success(etcPermissionResponse);
    }
}
