package com.icetech.park.service.report.pnc.impl;

import javax.annotation.Resource;

import com.icetech.cloudcenter.api.order.OrderEnterService;
import com.icetech.cloudcenter.domain.request.EnterRequest;
import com.icetech.park.mongo.document.EnterRecord;
import com.icetech.park.service.record.EnterRecordService;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;

import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class EnterServiceImpl extends AbstractService implements ReportService {
    @Autowired
    private OrderEnterService orderEnterService;
    @Resource
    private EnterRecordService enterRecordService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        EnterRequest enterRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), EnterRequest.class);

        //参数校验
        verifyParams(enterRequest);
        enterRequest.setParkId(parkId);

        // 记录上报信息
        addEnterRecord(enterRequest);

        // 开始处理业务
        ObjectResponse<Map<String, Object>> objectResponse = orderEnterService.enter(enterRequest, dataCenterBaseRequest.getParkCode());
        if (objectResponse == null){
            return ObjectResponse.failed(CodeConstants.ERROR);
        }else{
            return objectResponse;
        }
    }

    private void addEnterRecord(EnterRequest request) {
        EnterRecord record = new EnterRecord();
        BeanUtils.copyProperties(request,record);
        record.setOrderNum(request.getOrderId());
        record.setImage(request.getEnterImage());
        record.setSmallImage(request.getSmallImage());
        enterRecordService.saveRecordAsync(record);
    }
}
