package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.park.ParkLicenseService;
import com.icetech.cloudcenter.domain.response.AccessInfoDto;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.response.pnc.DownConnectResponse;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Random;

@Slf4j
@Service
public class DownConnectParamServiceImpl extends AbstractService implements ReportService {
    private int VERSION_N = 1;
    private int VERSION_v = 2;
    @Autowired
    private ParkLicenseService parkLicenseService;
    @Value("${cloudcenter.license.dsttopic}")
    private String dstTopic;
    @Value("${cloudcenter.license.clientid}")
    private String clientId;
    @Value("${cloudcenter.license.endpoint}")
    private String endPoint;
    @Value("${cloudcenter.license.bucketname}")
    private String bucketName;
    @Value("${cloudcenter.license.servaddr}")
    private String servAddr;
    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        //版本号判断
        String versionNum = dataCenterBaseRequest.getVersionNum();
        ObjectResponse<AccessInfoDto> accessInfoByType = null;
        if(versionNum.startsWith("n") || versionNum.startsWith("N")){
            accessInfoByType = parkLicenseService.getAccessInfoByType(VERSION_N);
        }else if(versionNum.startsWith("v") || versionNum.startsWith("V")) {
            accessInfoByType = parkLicenseService.getAccessInfoByType(VERSION_v);
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_400, "版本号格式不正确");
        }
        if(ObjectResponse.isSuccess(accessInfoByType)){
            DownConnectResponse licenseResponse = new DownConnectResponse();
            AccessInfoDto data = accessInfoByType.getData();
            licenseResponse.setAccessKeyId(salt(data.getAccessKeyId()));
            licenseResponse.setAccessKeySecret(salt(data.getAccessKeySecret()));
            licenseResponse.setDstTopic(dstTopic);
            licenseResponse.setClienTid(clientId);
            licenseResponse.setBucketName(bucketName);
            licenseResponse.setEndPoint(endPoint);
            licenseResponse.setServAddr(servAddr);
            return ObjectResponse.success(licenseResponse);
        }
        return ObjectResponse.failed(CodeConstants.ERROR);
    }

    /**
     *加盐 3位加一个
     */
    public static String salt(String license) {
        String salt = "0123456789abcdefghijklmnopqrstuvwxyz";
        int charLength = salt.length();
        Random random = new Random();
        char[] chars1 = salt.toCharArray();
        char[] chars = license.toCharArray();
        StringBuffer sf = new StringBuffer();
        int key = 0;
        for (int i = 0; i < chars.length; i++) {
            if(key%3 == 0 && key != 0){
                int i1 = random.nextInt(charLength);
                System.out.println(chars1[i1]);
                sf.append(chars1[i1]);
            }
            key = key +1;
            sf.append(chars[i]);
        }
        sf.append(chars1[random.nextInt(charLength)]);
        return sf.toString();
    }

    /**
     * 测试方法
     * @param args
     */
    public static void main(String[] args) {
        String pass= "50b99cf8803544808738f5976dfb6666#1qa2ws3ed4rf";
        try {
            System.out.println(DigestUtils.md5Hex(pass));
        }catch (Exception e){
            log.warn(String.valueOf(e.getMessage()), e);
        }
        String charStr = "0123456789abcdefghijklmnopqrstuvwxyz";
        String s = "LTAI4Feik71ksCdPWrfpPcpf";
        int charLength = charStr.length();
        Random random = new Random();
        char[] chars1 = charStr.toCharArray();
        char[] chars = s.toCharArray();
        StringBuffer sf = new StringBuffer();
        int key = 0;
        for (int i = 0; i < chars.length; i++) {
            if(key%3 == 0 && key != 0){
                int i1 = random.nextInt(charLength);
                System.out.println(chars1[i1]);
                sf.append("#");
            }
            key = key +1;
            sf.append(chars[i]);
        }
        sf.append("#");
        System.out.println(sf.toString());
    }
}
