package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.park.ParkDeviceService;
import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.basics.dao.device.HeartbeatOfflineDao;
import com.icetech.basics.domain.entity.device.HeartbeatOffline;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.DeviceStatusRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
@Slf4j
public class DeviceStatusSyncServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private ParkDeviceService parkDeviceService;
    @Autowired
    private ParkDeviceDao parkDeviceDao;
    @Autowired
    private HeartbeatOfflineDao heartbeatOfflineDao;

    //设备类型，1：在线，2：离线，3：故障，4：告警
    private static final int[] DEVICE_STATUS = {1, 2, 3, 4};

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {

        DeviceStatusRequest deviceStatusRequest = JsonUtils.convert2bean(
                dataCenterBaseRequest.getBizContent(), DeviceStatusRequest.class);

        //参数校验
        verifyParams(deviceStatusRequest);
        Integer deviceStatus = deviceStatusRequest.getDeviceStatus();
        Long reportTime = dataCenterBaseRequest.getTimestamp();

        String deviceNo = deviceStatusRequest.getDeviceNo();
        ParkDevice device = parkDeviceDao.getByDeviceNo(parkId, deviceNo);
        if (device == null) {
            log.info("设备状态更新，未找到设备编号[{}]", deviceNo);
            return ObjectResponse.failed(CodeConstants.ERROR_404);
        }
        //如果上报状态和平台保存的设备状态不一致时
        if (!deviceStatus.equals(device.getStatus())) {
            if (deviceStatus.equals(DEVICE_STATUS[1])) {
                HeartbeatOffline heartbeatOffline = new HeartbeatOffline();
                heartbeatOffline.setParkId(parkId);
                Date endTime = device.getEndUpdatetime();
                heartbeatOffline.setLastConnectionTime(endTime == null ?
                        reportTime : endTime.getTime() / 1000);
                heartbeatOffline.setDeviceNo(deviceNo);
                heartbeatOfflineDao.insert(heartbeatOffline);
            } else if (deviceStatus.equals(DEVICE_STATUS[0])) {
                HeartbeatOffline ret = heartbeatOfflineDao.selectLast(parkId, deviceNo);
                if (ret != null) {
                    ret.setReconnectTime(reportTime);
                    ret.setOffTime(reportTime - ret.getLastConnectionTime());
                    heartbeatOfflineDao.updateById(ret);
                }
            }
        }
        if ((deviceStatusRequest.getProductModel() != null
                && !deviceStatusRequest.getProductModel().equals(device.getProductModel()))
                || (deviceStatusRequest.getFirmwareVersion() != null
                && !deviceStatusRequest.getFirmwareVersion().equals(device.getFirmwareVersion()))) {
            ParkDevice deviceUpdate = new ParkDevice();
            deviceUpdate.setId(device.getId());
            deviceUpdate.setProductModel(deviceStatusRequest.getProductModel());
            deviceUpdate.setFirmwareVersion(deviceStatusRequest.getFirmwareVersion());
            parkDeviceService.updateDevice(deviceUpdate);
        }
        return parkDeviceService.modifyStatus(parkId,
                deviceStatusRequest.getDeviceNo(), deviceStatusRequest.getDeviceStatus(),
                deviceStatusRequest.getFailureCause(), deviceStatusRequest.getWrongTime());
    }

}
