package com.icetech.park.service.report.pnc.impl;

import com.icetech.basics.dao.device.ParkDeviceDao;
import com.icetech.basics.domain.entity.device.ParkDevice;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.request.pnc.DeviceInfoRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceInfoServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private ParkDeviceDao parkDeviceDao;

    //操作类型，1：增加，2：删除，3：修改
    private static final int[] OPER_TYPE = {1,2,3};

    //删除记录的标记
    private static final int DEL_FLAG = 1;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {

        DeviceInfoRequest deviceInfoRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), DeviceInfoRequest.class);

        //参数校验
        verifyParams(deviceInfoRequest);

        ParkDevice parkDevice_para = new ParkDevice();
        parkDevice_para.setParkId(parkId);
        parkDevice_para.setDeviceNo(deviceInfoRequest.getDeviceNo());
        ParkDevice parkDevice_result = parkDeviceDao.selectByParam(parkDevice_para);
        int operType = deviceInfoRequest.getOperType();
        if (parkDevice_result != null){
            if (operType == OPER_TYPE[0]){
                return ObjectResponse.failed(CodeConstants.ERROR_405);
            }else if (operType == OPER_TYPE[1]){
                ParkDevice parkDevice = new ParkDevice();
                parkDevice.setParkId(parkId);
                parkDevice.setDeviceNo(deviceInfoRequest.getDeviceNo());
                parkDevice.setDelFlag(DEL_FLAG);
                parkDeviceDao.updateById(parkDevice);
            }else if (operType == OPER_TYPE[2]){
                parkDeviceDao.updateById(getParkDevice(deviceInfoRequest, parkId));
            }
        }else{
            if (operType == OPER_TYPE[0]){
                parkDeviceDao.insert(getParkDevice(deviceInfoRequest, parkId));
            }else if (operType == OPER_TYPE[1]){
                return ObjectResponse.failed(CodeConstants.ERROR_405);
            }else if (operType == OPER_TYPE[2]){
                //修改操作，表中无记录时，新增记录
                parkDeviceDao.insert(getParkDevice(deviceInfoRequest, parkId));
            }
        }

        return ObjectResponse.success();
    }

    /**
     * 获取实体对象
     * @param deviceInfoRequest
     * @param parkId
     * @return
     */
    private ParkDevice getParkDevice(DeviceInfoRequest deviceInfoRequest, Long parkId) {
        ParkDevice parkDevice = new ParkDevice();
        parkDevice.setParkId(parkId);
        parkDevice.setDeviceNo(deviceInfoRequest.getDeviceNo());
        parkDevice.setType(deviceInfoRequest.getDeviceType());
        parkDevice.setIp(deviceInfoRequest.getDeviceIp());
        parkDevice.setPort(deviceInfoRequest.getDevicePort());
        return parkDevice;
    }
}
