package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.order.ComplateOrderService;
import com.icetech.cloudcenter.domain.request.ComplateOrderRequest;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.park.service.report.pnc.AbstractExitService;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ComplateOrderServiceImpl extends AbstractExitService implements ReportService {

    @Autowired
    private ComplateOrderService complateOrderService;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {
        ComplateOrderRequest complateOrderRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), ComplateOrderRequest.class);
        complateOrderRequest.setParkId(parkId);
        /**
         * 参数校验
         */
        if (verifyParams(complateOrderRequest)){
            ObjectResponse objectResponse = complateOrderService.complateOrder(complateOrderRequest);
            if (objectResponse == null) {
                return ObjectResponse.failed(CodeConstants.ERROR);
            } else {
                return objectResponse;
            }
        }else{
            return ObjectResponse.failed(CodeConstants.ERROR_400);
        }

    }

}
