package com.icetech.park.service.report.pnc.impl;

import com.alibaba.fastjson.JSON;
import com.icetech.cloudcenter.domain.constants.RedisConstants;
import com.icetech.cloudcenter.domain.request.pnc.ChargeStatusRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.cloudcenter.domain.response.pnc.ParkStatusResponse;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.DateTools;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.utils.RedisUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChargeStatusServiceImpl extends AbstractService implements ReportService {
    @Autowired
    private RedisUtils redisUtils;

    @Override
    public ObjectResponse report(DataCenterBaseRequest baseRequest, Long parkId) {
        ChargeStatusRequest request = JSON.parseObject(JSON.toJSONString(baseRequest.getBizContent()), ChargeStatusRequest.class);
        //开始处理业务
        Long cloudTime = DateTools.unixTimestamp();
        request.setTime(cloudTime);
        String redisKey = RedisConstants.PNC_HEARTBEAT_CHARGE_TIME_PREFIX + parkId;
        redisUtils.hPut(redisKey, request.getId().toString(), request);
        redisUtils.expire(redisKey, 3 * 60 * 60);  // 过期时间3小时
        // 返回结果
        ParkStatusResponse parkStatusResponse = new ParkStatusResponse();
        parkStatusResponse.setTime(cloudTime);
        return ObjectResponse.success(parkStatusResponse);
    }
}
