package com.icetech.park.service.report.pnc.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.icetech.basics.domain.entity.charge.Charge24charge;
import com.icetech.basics.domain.entity.charge.Charge24chargeSet;
import com.icetech.basics.domain.entity.charge.ChargeDaynight;
import com.icetech.basics.domain.entity.charge.ChargeDuration;
import com.icetech.basics.domain.entity.charge.ChargeNaturalday;
import com.icetech.basics.domain.entity.charge.ChargeOnce;
import com.icetech.basics.domain.entity.park.ParkChargeconfig;
import com.icetech.basics.domain.entity.park.ParkChargeconfig.BilltypeEnum;
import com.icetech.park.domain.entity.park.ParkGuide;
import com.icetech.park.service.report.pnc.ReportService;
import com.icetech.third.domain.entity.third.SendInfo;
import com.icetech.cloudcenter.domain.enumeration.DownServiceEnum;
import com.icetech.cloudcenter.domain.request.pnc.ChargeRuleUpRequest;
import com.icetech.cloudcenter.domain.request.pnc.ChargeRuleUpRequest.NaturalDayInfo;
import com.icetech.cloudcenter.domain.request.pnc.ChargeRuleUpRequest.DayNightInfo;
import com.icetech.cloudcenter.domain.request.pnc.ChargeRuleUpRequest.OnceInfo;
import com.icetech.cloudcenter.domain.request.pnc.ChargeRuleUpRequest.DurationInfo;
import com.icetech.cloudcenter.domain.request.pnc.ChargeRuleUpRequest.StepChargeDetail;
import com.icetech.cloudcenter.domain.request.pnc.ChargeRuleUpRequest.Hour24Info;
import com.icetech.cloudcenter.domain.request.pnc.ChargeRuleUpRequest.Hour24Detail;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.basics.service.charge.impl.Charge24chargeServiceImpl;
import com.icetech.basics.service.charge.impl.Charge24chargeSetServiceImpl;
import com.icetech.basics.service.charge.impl.ChargeDaynightServiceImpl;
import com.icetech.basics.service.charge.impl.ChargeDurationServiceImpl;
import com.icetech.basics.service.charge.impl.ChargeNaturaldayServiceImpl;
import com.icetech.basics.service.charge.impl.ChargeOnceServiceImpl;
import com.icetech.park.service.charge.ChargeServiceImpl;
import com.icetech.basics.service.charge.impl.ParkChargeConfigServiceImpl;
import com.icetech.park.service.park.impl.ParkGuideServiceImpl;
import com.icetech.third.service.third.SendInfoServiceImpl;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.constants.CodeConstantsEnum;
import com.icetech.common.constants.RedisKeyConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.exception.ResponseBodyException;
import com.icetech.db.mybatis.base.service.impl.BaseServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 计费规则上报接口
 */
@Slf4j
@Service
public class ChargeRuleUpServiceImpl extends AbstractService implements ReportService {
    @Autowired
    private ChargeServiceImpl chargeService;
    @Autowired
    private ParkChargeConfigServiceImpl parkChargeConfigService;
    @Autowired
    private ChargeNaturaldayServiceImpl chargeNaturaldayService;
    @Autowired
    private ChargeDaynightServiceImpl chargeDaynightService;
    @Autowired
    private Charge24chargeServiceImpl charge24chargeService;
    @Autowired
    private Charge24chargeSetServiceImpl charge24chargeSetService;
    @Autowired
    private ChargeOnceServiceImpl chargeOnceService;
    @Autowired
    private ChargeDurationServiceImpl chargeDurationService;
    @Autowired
    private ParkGuideServiceImpl parkGuideService;
    @Autowired
    private SendInfoServiceImpl sendInfoService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Override
    @Transactional
    public ObjectResponse report(DataCenterBaseRequest baseRequest, Long parkId) throws Exception {
        if (baseRequest.getBizContent() == null) return ObjectResponse.failed(CodeConstantsEnum.ERROR_400);
        List<ChargeRuleUpRequest> requests = JSON.parseArray(JSON.toJSONString(baseRequest.getBizContent()), ChargeRuleUpRequest.class);
        if (CollectionUtils.isEmpty(requests)) return ObjectResponse.failed(CodeConstantsEnum.ERROR_400);
        List<ParkChargeconfig> parkChargeConfigs = new LinkedList<>();
        List<ChargeNaturalday> chargeNaturalDays = new LinkedList<>();
        List<ChargeDaynight> chargeDayNights = new LinkedList<>();
        List<ChargeOnce> chargeOnces = new LinkedList<>();
        List<ChargeDuration> chargeDurations = new LinkedList<>();
        List<Charge24charge> charge24Charges = new LinkedList<>();
        List<Charge24chargeSet> charge24ChargeSets = new LinkedList<>();

        for (ChargeRuleUpRequest request : requests) {
            ParkChargeconfig config = buildParkChargeConfig(parkId, request);
            parkChargeConfigs.add(config);
            if (request.getBilltype() == BilltypeEnum.通用自然天.type) {
                NaturalDayInfo info = request.getChargeRule().toJavaObject(NaturalDayInfo.class);
                ChargeNaturalday charge = buildChargeNaturalDay(parkId, request, info);
                chargeNaturalDays.add(charge);
                fillBillMethodList(request.getBilltypecode(), request.getBilltype(), 1, info.getOneBillmethod(), info.getFirstConfig(), chargeOnces, chargeDurations);
                if (info.getIsspecialdaycharge() == 1) {    // 区分工作日非工作日计费
                    fillBillMethodList(request.getBilltypecode(), request.getBilltype(), 2, info.getTwoBillmethod(), info.getTwoConfig(), chargeOnces, chargeDurations);
                }
            } else if (request.getBilltype() == BilltypeEnum.白天夜间收费.type) {
                DayNightInfo info = request.getChargeRule().toJavaObject(DayNightInfo.class);
                ChargeDaynight charge = buildChargeDayNight(parkId, request, info);
                chargeDayNights.add(charge);
                fillBillMethodList(request.getBilltypecode(), request.getBilltype(), 1, info.getDayBillmethod(), info.getDayConfig(), chargeOnces, chargeDurations);
                fillBillMethodList(request.getBilltypecode(), request.getBilltype(), 2, info.getNightBillmethod(), info.getNightConfig(), chargeOnces, chargeDurations);
            } else if (request.getBilltype() == BilltypeEnum.二十四小时计费.type) {
                Hour24Info info = request.getChargeRule().toJavaObject(Hour24Info.class);
                Charge24charge charge = buildCharge24Charge(parkId, request, info);
                charge24Charges.add(charge);
                if (info.getDetails() == null || info.getDetails().size() != 48) {
                    throw new ResponseBodyException(CodeConstants.ERROR_400, "24H计费规则[" + request.getBilltypecode() + "]详情不全");
                } else {
                    for (Hour24Detail detail : info.getDetails()) {
                        Charge24chargeSet chargeSet = buildCharge24ChargeSet(parkId, request.getBilltypecode(), detail);
                        charge24ChargeSets.add(chargeSet);
                    }
                }
            } else {
                log.warn("未知计费规则类型|{}|{}|{}", request.getBilltypecode(), request.getBilltypename(), request.getBilltype());
            }
        }

        List<ParkChargeconfig> existsConfigs = parkChargeConfigService.list(Wrappers.lambdaQuery(ParkChargeconfig.class).eq(ParkChargeconfig::getParkId, parkId));
        Set<String> cacheKeys = new HashSet<>(existsConfigs.size() + 1);
        cacheKeys.add(RedisKeyConstants.KEY_PREFIX_CHARGE_PARK + parkId);
        if (CollectionUtils.isNotEmpty(existsConfigs)) {
            Set<String> existsTypeCodes = existsConfigs.stream().map(existsConfig -> {
                cacheKeys.add(RedisKeyConstants.KEY_PREFIX_CHARGE_NATURAL_CODE + existsConfig.getBilltypecode());
                cacheKeys.add(RedisKeyConstants.KEY_PREFIX_CHARGE_DAY_NIGHT_CODE + existsConfig.getBilltypecode());
                cacheKeys.add(RedisKeyConstants.KEY_PREFIX_CHARGE_24HOUR_CODE + existsConfig.getBilltypecode());
                return existsConfig.getBilltypecode();
            }).collect(Collectors.toSet());
            parkChargeConfigService.remove(Wrappers.lambdaQuery(ParkChargeconfig.class).eq(ParkChargeconfig::getParkId, parkId).in(ParkChargeconfig::getBilltypecode, existsTypeCodes));
            chargeNaturaldayService.remove(Wrappers.lambdaQuery(ChargeNaturalday.class).eq(ChargeNaturalday::getParkId, parkId).in(ChargeNaturalday::getBilltypecode, existsTypeCodes));
            chargeDaynightService.remove(Wrappers.lambdaQuery(ChargeDaynight.class).eq(ChargeDaynight::getParkId, parkId).in(ChargeDaynight::getBilltypecode, existsTypeCodes));
            chargeOnceService.remove(Wrappers.lambdaQuery(ChargeOnce.class).in(ChargeOnce::getBilltypecode, existsTypeCodes));
            chargeDurationService.remove(Wrappers.lambdaQuery(ChargeDuration.class).in(ChargeDuration::getBilltypecode, existsTypeCodes));
            charge24chargeService.remove(Wrappers.lambdaQuery(Charge24charge.class).eq(Charge24charge::getParkId, parkId).in(Charge24charge::getBilltypecode, existsTypeCodes));
            charge24chargeSetService.remove(Wrappers.lambdaQuery(Charge24chargeSet.class).in(Charge24chargeSet::getBilltypecode, existsTypeCodes));
        }
        saveBatch(parkChargeConfigService, parkChargeConfigs);
        saveBatch(chargeNaturaldayService, chargeNaturalDays);
        saveBatch(chargeDaynightService, chargeDayNights);
        saveBatch(chargeOnceService, chargeOnces);
        saveBatch(chargeDurationService, chargeDurations);
        saveBatch(charge24chargeService, charge24Charges);
        saveBatch(charge24chargeSetService, charge24ChargeSets);
        ParkGuide guide = new ParkGuide();
        guide.setParkId(parkId);
        guide.setStep6(1);
        parkGuideService.updateByParkId(guide);
        // 计费规则下发, serviceId取车场ID
        sendInfoService.save(SendInfo.buildUnneeded(parkId, parkId, DownServiceEnum.计费规则.getServiceType(), "本地上报"));

        stringRedisTemplate.delete(cacheKeys);  // 移除缓存信息
        return ObjectResponse.success();
    }

    private <T> boolean saveBatch(BaseServiceImpl<?, T> baseService, Collection<T> data) {
        if (CollectionUtils.isEmpty(data)) return true;
        return baseService.saveBatch(data);
    }

    private void fillBillMethodList(String billTypeCode, int billType, int billGroup, int billMethod, JSONObject billConfig,
                                    List<ChargeOnce> chargeOnces, List<ChargeDuration> chargeDurations) {
        if (billMethod == 1) {
            OnceInfo onceInfo = billConfig.toJavaObject(OnceInfo.class);
            ChargeOnce charge = buildChargeOnce(billTypeCode, billType, billGroup, onceInfo);
            chargeOnces.add(charge);
        } else if (billMethod == 2) {
            DurationInfo durationInfo = billConfig.toJavaObject(DurationInfo.class);
            ChargeDuration charge = buildChargeDuration(billTypeCode, billType, billGroup, durationInfo);
            chargeDurations.add(charge);
            for (StepChargeDetail detail : durationInfo.getStepChargeDetails()) {
                charge = buildChargeDuration(billTypeCode, billType, billGroup, detail);
                chargeDurations.add(charge);
            }
        } else {
            log.warn("未知计费方式|{}|{}", billTypeCode, billMethod);
        }
    }

    private ParkChargeconfig buildParkChargeConfig(long parkId, ChargeRuleUpRequest request) {
        ParkChargeconfig config = new ParkChargeconfig();
        config.setParkId(parkId);
        config.setBilltypecode(request.getBilltypecode());
        config.setBilltype(request.getBilltype());
        config.setDefaultCharge(request.getIsDefault());
        config.setBilltypename(request.getBilltypename());
//        config.setLicensePlateType();
//        config.setRegionId();
        config.setStatus(0);
        return config;
    }

    private ChargeNaturalday buildChargeNaturalDay(long parkId, ChargeRuleUpRequest request, NaturalDayInfo info) {
        ChargeNaturalday charge = new ChargeNaturalday();
        charge.setBilltypecode(request.getBilltypecode());
        charge.setBilltypename(request.getBilltypename());
        charge.setParkId(parkId);
        charge.setBillmethod(info.getOneBillmethod());
        charge.setNoworkBillmethod(info.getTwoBillmethod());
        charge.setIsspecialdaycharge(info.getIsspecialdaycharge());
//        charge.setSpecialdaytype(info.getSpecialdaytype());   // 忽略
        charge.setFreetime(info.getFreetime());
        charge.setDaynightmaxfeeusing(info.getDaynightmaxfeeusing());
        charge.setDaynightmaxfee(info.getDaynightmaxfee());
        charge.setStatus(0);
//        charge.setRemark(info.getRemark());
//        charge.setAdder(info.getAdder());
//        charge.setAddtime(info.getAddtime());
//        charge.setUpdateUser(info.getUpdateUser());
//        charge.setUpdateTime(info.getUpdateTime());
        charge.setDaynightmaxfeeBig(info.getDaynightmaxfeeBig());
        charge.setIsSmallbigcarSet(info.getIsSmallbigcarSet());
        charge.setMaxFeeType(info.getDaynightmaxfeetype());
        charge.setCountType(info.getDaynightmaxfeecounttype());
        charge.setIsFreetimeOnce(info.getIsFreetimeOnce());
        return charge;
    }

    private ChargeDaynight buildChargeDayNight(long parkId, ChargeRuleUpRequest request, DayNightInfo info) {
        ChargeDaynight charge = new ChargeDaynight();
        charge.setBilltypecode(request.getBilltypecode());
        charge.setBilltypename(request.getBilltypename());
        charge.setParkId(parkId);
        charge.setBillmethodday(info.getDayBillmethod());
        charge.setBillmethodnight(info.getNightBillmethod());
//        charge.setIsspecialdaycharge(info.getIsspecialdaycharge());
//        charge.setSpecialdaytype(info.getSpecialdaytype());
        charge.setFreetime(info.getFreetime());
        charge.setDaynightmaxfeeusing(info.getDaynightmaxfeeusing());
        charge.setDaynightmaxfee(info.getDaynightmaxfee());
        charge.setDaybegin(info.getDaybegin());
        charge.setNightbegin(info.getNightbegin());
        charge.setDaymaxfeeusing(info.getDaymaxfeeusing());
        charge.setDaymaxfee(info.getDaymaxfee());
        charge.setNightmaxfeeusing(info.getNightmaxfeeusing());
        charge.setNightmaxfee(info.getNightmaxfee());
        charge.setStatus(0);
//        charge.setRemark(info.getRemark());
//        charge.setAdder(info.getAdder());
//        charge.setAddtime(info.getAddtime());
//        charge.setUpdateUser(info.getUpdateUser());
//        charge.setUpdateTime(info.getUpdateTime());
        charge.setDaynightmaxfeeBig(info.getDaynightmaxfeeBig());
        charge.setDaymaxfeeBig(info.getDaymaxfeeBig());
        charge.setNightmaxfeeBig(info.getNightmaxfeeBig());
        charge.setIsSmallbigcarSet(info.getIsSmallbigcarSet());
        charge.setMaxFeeType(info.getDaynightmaxfeetype());
        charge.setCountType(info.getDaynightmaxfeecounttype());
        charge.setIsFreetimeOnce(info.getIsFreetimeOnce());
        return charge;
    }

    private ChargeOnce buildChargeOnce(String billTypeCode, int billType, int billGroup, OnceInfo info) {
        ChargeOnce charge = new ChargeOnce();
        charge.setBilltypecode(billTypeCode);
        charge.setIsnaturaldayfee(billType);
        charge.setDayornightfeemark(billGroup);
        charge.setIsopenoncecharge(info.getIsopenoncecharge());
        charge.setOncechargefee(info.getOncechargefee());
        charge.setIsopenother2(info.getIsopenother2());
        charge.setTimeFrame(info.getTimeFrame());
        charge.setTimeFrameOncefee(info.getTimeFrameOncefee());
        charge.setOtherTimeframeOncefee(info.getOtherTimeframeOncefee());
        charge.setIsattachoption(info.getIsattachoption());
        charge.setOverTime(info.getOverTime());
        charge.setAddOvernightFee(info.getAddOvernightFee());
        charge.setOncechargefeeBig(info.getOncechargefeeBig());
        charge.setTimeFrameOncefeeBig(info.getTimeFrameOncefeeBig());
        charge.setOtherTimeframeOncefeeBig(info.getOtherTimeframeOncefeeBig());
        charge.setAddOvernightFeeBig(info.getAddOvernightFeeBig());
        return charge;
    }

    private ChargeDuration buildChargeDuration(String billTypeCode, int billType, int billGroup, DurationInfo info) {
        ChargeDuration charge = new ChargeDuration();
        charge.setBilltypecode(billTypeCode);
        charge.setIsnaturaldayfee(billType);
        charge.setDayornightfeemark(billGroup);
        charge.setStartTimeModule(0);
        charge.setEndTimeModule(0);
        charge.setFeespantime(info.getFeespantime());
        charge.setFeespanrate(info.getFeespanrate());
        charge.setFeespanrateBig(info.getFeespanrateBig());
        charge.setIsOverTimeSet(info.getIsOverTimeSet());
        charge.setOverTime(info.getOverTime());
        return charge;
    }

    private ChargeDuration buildChargeDuration(String billTypeCode, int billType, int billGroup, StepChargeDetail detail) {
        ChargeDuration charge = new ChargeDuration();
        charge.setBilltypecode(billTypeCode);
        charge.setIsnaturaldayfee(billType);
        charge.setDayornightfeemark(billGroup);
        charge.setStartTimeModule(detail.getStartTimeModule());
        charge.setEndTimeModule(detail.getEndTimeModule());
        charge.setFeespantime(detail.getFeespantime());
        charge.setFeespanrate(detail.getFeespanrate());
        charge.setFeespanrateBig(detail.getFeespanrateBig());
        charge.setIsOverTimeSet(2);
        charge.setOverTime(0);
        return charge;
    }

    private Charge24charge buildCharge24Charge(long parkId, ChargeRuleUpRequest request, Hour24Info info) {
        Charge24charge charge = new Charge24charge();
        charge.setBilltypecode(request.getBilltypecode());
        charge.setBilltypename(request.getBilltypename());
        charge.setParkId(parkId);
        charge.setFreetime(info.getFreetime());
        charge.setDaynightmaxfeeusing(info.getDaynightmaxfeeusing());
        charge.setDaynightmaxfee(info.getDaynightmaxfee());
        charge.setDivisionTime(info.getDivisionTime());
        charge.setIsOverTimeSet(info.getIsOverTimeSet());
        charge.setFeespantimestep(info.getFeespantimestep());
        charge.setFeespanratestep(info.getFeespanratestep());
        charge.setStatus(0);
//        charge.setRemark(info.getRemark());
//        charge.setAdder(info.getAdder());
//        charge.setAddtime(info.getAddtime());
//        charge.setUpdateUser(info.getUpdateUser());
//        charge.setUpdateTime(info.getUpdateTime());
        charge.setDaynightmaxfeeBig(info.getDaynightmaxfeeBig());
        charge.setFeespanratestepBig(info.getFeespanratestepBig());
        charge.setIsSmallbigcarSet(info.getIsSmallbigcarSet());
        charge.setMaxFeeType(info.getDaynightmaxfeetype());
        charge.setCountType(info.getDaynightmaxfeetype());
        charge.setIsFreetimeOnce(info.getIsFreetimeOnce());
        return charge;
    }

    private Charge24chargeSet buildCharge24ChargeSet(long parkId, String billTypeCode, Hour24Detail info) {
        Charge24chargeSet charge = new Charge24chargeSet();
        charge.setBilltypecode(billTypeCode);
        charge.setFeespantime(info.getFeespantime());
        charge.setFeespanrate(info.getFeespanrate());
        charge.setFeespanrateBig(info.getFeespanrateBig());
        return charge;
    }
}
