package com.icetech.park.service.report.pnc.impl;

import com.icetech.cloudcenter.api.park.ParkService;
import com.icetech.basics.domain.entity.park.ParkInoutdevice;
import com.icetech.common.constants.CodeConstants;
import com.icetech.common.domain.response.ObjectResponse;
import com.icetech.common.utils.JsonUtils;
import com.icetech.fee.dao.CashRefundDao;
import com.icetech.fee.domain.entity.CashRefund;
import com.icetech.cloudcenter.domain.request.pnc.CashRefundRequest;
import com.icetech.cloudcenter.domain.request.pnc.DataCenterBaseRequest;
import com.icetech.park.service.AbstractService;
import com.icetech.park.service.handle.PublicHandle;
import com.icetech.park.service.report.pnc.ReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;

@Service
public class CashRefundServiceImpl extends AbstractService implements ReportService {

    @Autowired
    private ParkService parkService;
    @Autowired
    private PublicHandle publicHandle;
    @Autowired
    private CashRefundDao cashRefundDao;

    @Override
    public ObjectResponse report(DataCenterBaseRequest dataCenterBaseRequest, Long parkId) {

        CashRefundRequest cashRefundRequest = JsonUtils.convert2bean(dataCenterBaseRequest.getBizContent(), CashRefundRequest.class);

        //参数校验
        verifyParams(cashRefundRequest);

        /**
         * 开始处理业务
         */
        ObjectResponse<ParkInoutdevice> inOutDeviceByCode = parkService.getInOutDeviceByCode(parkId, cashRefundRequest.getChannelId());
        if (!ObjectResponse.isSuccess(inOutDeviceByCode)) {
            return ObjectResponse.failed(CodeConstants.ERROR_402, "channelId未被注册");
        } else {
            ParkInoutdevice inoutdevice = inOutDeviceByCode.getData();

            CashRefund cashRefund = new CashRefund();
            cashRefund.setParkId(parkId);
            cashRefund.setInandoutName(inoutdevice.getInandoutName());
            String orderNum = publicHandle.convert2OrderNum(parkId, cashRefundRequest.getOrderId());
            cashRefund.setOrderNum(orderNum);
            cashRefund.setPlateNum(cashRefundRequest.getPlateNum());
            cashRefund.setParkId(parkId);
            cashRefund.setDeviceNo(cashRefundRequest.getDeviceNo());
            cashRefund.setActualCash(new BigDecimal(cashRefundRequest.getActualCash()));
            cashRefund.setReceiveTime(new Date(cashRefundRequest.getReceiveTime() * 1000));
            cashRefundDao.insert(cashRefund);
            return ObjectResponse.success();
        }
    }

}
